/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class FGTR
extends AudioObject {
    private float[][] FGTArray;
    private int bCounter;
    private int gCounter;
    private int gDuration;
    private int grainsPerBuffer;
    private float bandwidthTop;
    private float bandwidthBottom;
    private float spatial;
    private float highestAmp;
    private float frequency;
    private float grainDuration;

    public FGTR(AudioObject ao) {
        super(ao, "[FGTR]");
    }

    public int work(float[] buffer) throws AOException {
        this.gCounter = 0;
        while (this.gCounter < this.grainsPerBuffer) {
            this.bCounter = (int)this.FGTArray[this.gCounter][0];
            this.gDuration = (int)this.FGTArray[this.gCounter][1];
            this.bandwidthTop = this.FGTArray[this.gCounter][2];
            this.bandwidthBottom = this.FGTArray[this.gCounter][3];
            this.spatial = this.FGTArray[this.gCounter][4];
            this.highestAmp = this.FGTArray[this.gCounter][5];
            this.frequency = (float)((double)(this.bandwidthTop + this.bandwidthBottom) * 0.5);
            int dCounter = 0;
            while ((float)dCounter < this.grainDuration) {
                buffer[this.bCounter] = buffer[this.bCounter] + (float)(Math.sin(Math.PI * 2 * (double)dCounter * (double)(this.frequency * (float)buffer.length / (float)(this.sampleRate * this.channels))) * (Math.sin(Math.PI * (double)((float)dCounter / this.grainDuration)) * (double)this.highestAmp));
                ++this.bCounter;
                ++dCounter;
            }
            ++this.gCounter;
        }
        return 0;
    }
}

