/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Granulator
extends AudioObject {
    private int grainDuration = 1323;
    private int envelopeType = 1;
    private int nog;
    private float cfm;
    private int cgd;
    private float[] grain;
    private float[] newbuf;
    private int grainCnt = 0;
    private int grainsPerSecond = 10;
    private float[] tailBuf;
    private float freqMod = 1.0f;
    private float[] inBuffer = null;
    private boolean inBufActive = false;
    private boolean ri = false;
    private boolean rgd = false;
    private int rdist = 0;
    private int rdisttemp = 0;
    private int gdb = 1000;
    private int gdt = 1000;
    private boolean rf = false;
    private float rfb = 0.99f;
    private float rft = 1.01f;
    private float[] durationArray;
    private float[] gpsArray;
    private float[] freqArray;
    private boolean premapped = false;

    public Granulator(AudioObject ao, int sampleRate, int channels, int duration, int gps) {
        super(ao, "[Granulator]");
        this.grainDuration = duration;
        this.grainsPerSecond = gps;
        this.cgd = 0;
        this.grain = new float[this.grainDuration];
        this.tailBuf = new float[0];
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public Granulator(AudioObject ao, int sampleRate, int channels, float[] durationArr, float[] gpsArr, float[] freqArr, boolean rif, boolean rgdf, boolean rff, int rd) {
        super(ao, "[Granulator]");
        this.durationArray = durationArr;
        this.gpsArray = gpsArr;
        this.freqArray = freqArr;
        this.grain = new float[(int)this.durationArray[0]];
        this.ri = rif;
        this.rgd = rgdf;
        this.rf = rff;
        this.tailBuf = new float[0];
        this.rdist = rd;
        this.premapped = true;
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public int work(float[] buffer) throws AOException {
        int i;
        if (this.inBuffer == null) {
            this.newbuf = new float[buffer.length];
            this.previous[0].nextWork(this.newbuf);
        } else {
            this.newbuf = new float[buffer.length];
            for (int i2 = 0; i2 < this.inBuffer.length && i2 < this.newbuf.length; ++i2) {
                this.newbuf[i2] = this.inBuffer[i2];
            }
            this.inBuffer = null;
        }
        if (this.grainsPerSecond <= 0) {
            this.grainsPerSecond = 1;
        }
        this.nog = (int)((float)this.newbuf.length / ((float)(this.sampleRate * this.channels) / (float)this.grainsPerSecond));
        if (this.nog <= 0) {
            this.nog = 1;
        }
        int tbg = this.newbuf.length / this.nog;
        for (i = 0; i < buffer.length && i < this.tailBuf.length; ++i) {
            int n = i;
            buffer[n] = buffer[n] + this.tailBuf[i];
        }
        this.tailBuf = new float[this.newbuf.length];
        this.inBufActive = true;
        for (i = 0; i < this.nog; ++i) {
            this.rdisttemp = this.rdist > 0 ? (int)(Math.random() * (double)this.rdist) : 0;
            int index = i * tbg + this.rdisttemp;
            this.setGrain(index - this.rdisttemp);
            for (int j = 0; j < this.grain.length; ++j) {
                if (index >= buffer.length) {
                    int n = index - buffer.length;
                    this.tailBuf[n] = this.tailBuf[n] + this.grain[j];
                } else {
                    int n = index;
                    buffer[n] = buffer[n] + this.grain[j];
                }
                ++index;
                ++this.grainCnt;
            }
        }
        this.inBufActive = false;
        return buffer.length;
    }

    public void setFreqMod(float fmod) {
        this.freqMod = fmod;
    }

    public void setGrainDuration(int gdur) {
        this.grainDuration = gdur;
    }

    public void setGrainsPerSecond(int gps) {
        this.grainsPerSecond = gps;
    }

    public void setEnvelopeType(int et) {
        this.envelopeType = et;
    }

    public void setRandomGrainDuration(boolean bool) {
        this.rgd = bool;
    }

    public void setRandomGrainBottom(int b) {
        this.gdb = b;
    }

    public void setRandomGrainTop(int t) {
        this.gdt = t;
    }

    public void setRandomIndex(boolean bool) {
        this.ri = bool;
    }

    public void setRandomFreq(boolean bool) {
        this.rf = bool;
    }

    public void setRandomDist(int rd) {
        this.rdist = rd;
    }

    public void setRandomFreqBottom(float fb) {
        this.rfb = fb;
    }

    public void setRandomFreqTop(float ft) {
        this.rft = ft;
    }

    private void setGrain(int index) throws AOException {
        if (this.ri) {
            index = (int)(Math.random() * (double)this.newbuf.length);
        }
        float[] buf = this.newbuf;
        this.cgd = this.rgd ? this.gdb + (int)(Math.random() * (double)this.gdt) : this.grainDuration;
        this.cfm = this.freqMod;
        if (this.rf) {
            this.cfm = (float)((double)this.rfb + Math.random() * (double)(this.rft - this.rfb));
        }
        if (this.inBufActive) {
            this.inBuffer = new float[this.newbuf.length];
            int ret = this.previous[0].nextWork(this.inBuffer);
            this.inBufActive = false;
        }
        this.grain = new float[this.cgd];
        int count = 0;
        float tmp = 0.0f;
        double skip = -1.0 / (double)((1.0f - this.cfm) / this.cfm);
        double remains = 0.0;
        int upSample = 0;
        if (skip < 0.0) {
            skip = -1.0 / skip;
            upSample = 1;
        }
        if (skip == 0.0) {
            upSample = 2;
        }
        int ind = 0;
        int i = index;
        while (true) {
            block21: {
                block22: {
                    block19: {
                        block20: {
                            if (i == buf.length) {
                                i = 0;
                                buf = this.inBuffer;
                            }
                            if (upSample != 0) break block19;
                            if (++ind < (int)(skip + remains)) break block20;
                            remains = (skip + remains) % 1.0;
                            ind = 0;
                            break block21;
                        }
                        if (count >= this.cgd) break;
                        this.grain[count++] = buf[i];
                        break block22;
                    }
                    if (upSample == 1) {
                        if (skip + remains >= 1.0) {
                            float p = (tmp - buf[i]) / (float)((int)skip + 1);
                            for (int k = 0; k < (int)(skip + remains); ++k) {
                                this.grain[count++] = p * (float)k + buf[i];
                                if (count == this.cgd) break;
                            }
                        }
                        if (count == this.cgd) break;
                        this.grain[count++] = buf[i];
                        tmp = buf[i];
                        remains = (skip + remains) % 1.0;
                    } else {
                        this.grain[count++] = buf[i];
                    }
                }
                if (count == this.cgd) break;
            }
            ++i;
        }
        if (this.envelopeType <= 1) {
            for (i = 0; i < this.cgd; ++i) {
                this.grain[i] = this.grain[i] * (float)(0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)this.cgd));
            }
        } else if (this.envelopeType == 3) {
            for (i = 0; i < this.cgd / 2; ++i) {
                this.grain[i] = this.grain[i] * 2.0f;
            }
            for (i = this.cgd / 2; i < this.cgd; ++i) {
                this.grain[i] = this.grain[i] * -2.0f + 2.0f;
            }
        } else {
            for (i = 0; i < this.cgd; ++i) {
                this.grain[i] = this.grain[i] * (float)Math.sin(Math.PI * (double)i / (double)this.cgd);
            }
        }
    }
}

