/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import java.util.Random;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Noise
extends AudioObject {
    public static final int WHITE_NOISE = 0;
    public static final int STEP_NOISE = 1;
    public static final int SMOOTH_NOISE = 2;
    public static final int BROWN_NOISE = 3;
    public static final int FRACTAL_NOISE = 4;
    public static final int GAUSSIAN_NOISE = 5;
    public static final int WALK_NOISE = 6;
    public static final int GENDYN_NOISE = 7;
    private static float sum;
    private static float[] rg;
    private static int k;
    private static int kg;
    private static int ng;
    private static int threshold;
    private static int np;
    private static int nbits;
    private static int numbPoints;
    private static float nr;
    private static float result;
    private static int counter;
    private int noiseType = 0;
    private int noiseDensity = 10;
    private float amp = 1.0f;
    private double standardDeviation = 0.25;
    private double mean = 0.0;
    private float walkLastValue = 0.0f;
    private float walkStepSize = 0.3f;
    private float walkMax = 1.0f;
    private float walkMin = -1.0f;
    private int walkNoiseDensity = 500;
    private long walkDensityCounter = 0L;
    private boolean walkVaryDensity = true;
    private int walkNoiseDensityMin = 1;
    private int walkNoiseDensityMax = 1500;
    private int walkNoiseDensityStepSize = 100;
    private Random RandomGenerator = new Random();
    private int gendynAmpGranularity = 128;
    private double gendynPrevTime = 50.0;
    private int gendynTimeMirror = 80;
    private int gendynAmpMirror = 80;
    private int tempAmpMirror;
    private boolean ampMirrorUpdate = false;
    private int gendynPointSize = 4;
    private double[] gendynAmpArray = new double[this.gendynPointSize];
    private double[] gendynTimeArray = new double[this.gendynPointSize];
    private boolean pointSizeReset = false;
    private int newPointSize;
    private double gendynAmp0 = 0.0;
    private int[] gendynIntArray;
    private double gendynIntArrayLength;
    private int gendynIntArrayCounter = 0;
    private double gendynTimeStepSize = 10.0;
    private double maxGendynTimeStepSize = 100.0;
    private double gendynAmpStepSize = 10.0;
    private double maxGendynAmpStepSize = 100.0;
    private int mirrorMax = 100;
    private boolean gendynGaussian = false;
    private double gendynPrimaryTimeStepSize = 10.0;
    private double gendynPrimaryAmpStepSize = 10.0;
    private int gendynPrimaryTimeMirror = 100;
    private int gendynPrimaryAmpMirror = 100;
    private int gendynInterpolation = 1;
    private boolean gendynGranularityUpdate = false;
    private int tempGendynGranularity;
    private float gnSampleVal;
    private int gnj;
    private int mgaCounter;
    private double mgaInc;
    private int index;
    private int jindex;
    private double rwNewVal;

    public Noise(Instrument inst) {
        this(inst, 0);
    }

    public Noise(Instrument inst, int noiseType) {
        this(inst, noiseType, 44100);
    }

    public Noise(Instrument inst, int noiseType, int sampleRate) {
        this(inst, noiseType, sampleRate, 1);
    }

    public Noise(Instrument inst, int noiseType, int sampleRate, int channels) {
        super(inst, sampleRate, "[WaveTable]");
        this.noiseType = noiseType;
        this.channels = channels;
        if (noiseType == 4) {
            this.setUpFractalMath();
        }
        if (noiseType == 7) {
            this.makeGendynArray();
        }
        for (int i = 0; i < this.gendynPointSize; ++i) {
            this.gendynAmpArray[i] = 50.0;
        }
    }

    public float getAmp() {
        return this.amp;
    }

    public void setAmp(float amp) {
        this.amp = amp;
    }

    private void setUpFractalMath() {
        nr /= 2.0f;
        while (nr > 1.0f) {
            ++nbits;
            np = 2 * np;
            nr /= 2.0f;
        }
        for (kg = 0; kg < nbits; ++kg) {
            Noise.rg[Noise.kg] = (float)Math.random();
        }
    }

    public int work(float[] buffer) throws AOException {
        int ret = 0;
        switch (this.noiseType) {
            case 0: {
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        buffer[ret++] = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                    }
                }
                break;
            }
            case 3: {
                float prev0 = 0.0f;
                float prev1 = 0.0f;
                float prev2 = 0.0f;
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        float current = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        float brownValue = (prev0 + prev1 + prev2 + current) / 4.0f;
                        buffer[ret++] = brownValue;
                        prev0 = prev1;
                        prev1 = prev2;
                        prev2 = current;
                    }
                }
                break;
            }
            case 1: {
                int density = this.noiseDensity;
                float temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        if (ret % density == 0) {
                            temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        }
                        buffer[ret++] = temp;
                    }
                }
                break;
            }
            case 2: {
                int density = this.noiseDensity;
                float temp = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                float temp2 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        if ((ret + 1) % density == 0) {
                            buffer[ret++] = temp2;
                            temp = temp2;
                            temp2 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                            continue;
                        }
                        buffer[ret++] = temp + (temp2 - temp) / (float)density * (float)(ret % density);
                    }
                }
                break;
            }
            case 4: {
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        if (counter % this.noiseDensity == 0) {
                            threshold = np;
                            ng = nbits;
                            while (k % threshold != 0) {
                                --ng;
                                threshold /= 2;
                            }
                            sum = 0.0f;
                            for (kg = 0; kg < nbits; ++kg) {
                                if (kg < ng) {
                                    Noise.rg[Noise.kg] = (float)Math.random();
                                }
                                sum += rg[kg];
                            }
                            result = (float)(((double)(sum / (float)nbits) - 0.17) * 2.85 - 1.0);
                            if ((double)result > 1.0) {
                                result = 1.0f;
                            } else if ((double)result < -1.0) {
                                result = -1.0f;
                            }
                        }
                        ++counter;
                        buffer[ret++] = result * this.amp;
                    }
                    if (counter <= 67000) continue;
                    counter = 0;
                }
                break;
            }
            case 5: {
                Random RNG = new Random();
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        float gaussValue = (float)(RNG.nextGaussian() * this.standardDeviation + this.mean);
                        if (gaussValue < -1.0f) {
                            gaussValue = -1.0f;
                        } else if (gaussValue > 1.0f) {
                            gaussValue = 1.0f;
                        }
                        buffer[ret++] = gaussValue * this.amp;
                    }
                }
                break;
            }
            case 6: {
                while (ret < buffer.length) {
                    for (int j = 0; j < this.channels; ++j) {
                        buffer[ret++] = this.walkLastValue;
                        ++this.walkDensityCounter;
                        if ((int)this.walkDensityCounter % this.walkNoiseDensity != 0) continue;
                        this.walkLastValue += (float)Math.random() * this.walkStepSize * 2.0f - this.walkStepSize;
                        while (this.walkLastValue > this.walkMax || this.walkLastValue < this.walkMin) {
                            if (this.walkLastValue > this.walkMax) {
                                this.walkLastValue -= (this.walkLastValue - this.walkMax) * 2.0f;
                            }
                            if (!(this.walkLastValue < this.walkMin)) continue;
                            this.walkLastValue += (this.walkMin - this.walkLastValue) * 2.0f;
                        }
                        if (!this.walkVaryDensity) continue;
                        this.walkNoiseDensity += (int)(Math.random() * (double)this.walkNoiseDensityStepSize * 2.0 - (double)this.walkNoiseDensityStepSize);
                        if (this.walkNoiseDensity < this.walkNoiseDensityMin) {
                            this.walkNoiseDensity = this.walkNoiseDensityMin;
                            continue;
                        }
                        if (this.walkNoiseDensity <= this.walkNoiseDensityMax) continue;
                        this.walkNoiseDensity = this.walkNoiseDensityMax;
                    }
                }
                break;
            }
            case 7: {
                this.gnSampleVal = 0.0f;
                while (ret < buffer.length) {
                    this.gnSampleVal = ((float)this.gendynIntArray[this.gendynIntArrayCounter] / (float)this.gendynAmpGranularity - 0.5f) * 2.0f;
                    if ((double)this.gnSampleVal > 1.0) {
                        this.gnSampleVal = 1.0f;
                    } else if ((double)this.gnSampleVal < -1.0) {
                        this.gnSampleVal = -1.0f;
                    }
                    this.gnj = 0;
                    while (this.gnj < this.channels) {
                        buffer[ret++] = this.gnSampleVal;
                        ++this.gnj;
                    }
                    ++this.gendynIntArrayCounter;
                    if (this.gendynIntArrayCounter < (int)this.gendynIntArrayLength) continue;
                    this.makeGendynArray();
                }
                break;
            }
            default: {
                System.err.println(this.name + "jMusic error: Noise type " + this.noiseType + " not supported yet.");
                System.exit(1);
            }
        }
        return ret;
    }

    private void makeGendynArray() {
        double diff;
        this.gendynTimeStepSize = this.randWalk(this.gendynTimeStepSize, this.gendynPrimaryTimeStepSize, this.gendynPrimaryTimeMirror, true);
        if (Math.abs(this.gendynTimeStepSize) > this.maxGendynTimeStepSize) {
            this.gendynTimeStepSize = this.maxGendynTimeStepSize;
        }
        this.gendynAmpStepSize = this.randWalk(this.gendynAmpStepSize, this.gendynPrimaryAmpStepSize, this.gendynPrimaryAmpMirror, false);
        if (Math.abs(this.gendynAmpStepSize) > this.maxGendynAmpStepSize) {
            this.gendynAmpStepSize = this.maxGendynAmpStepSize;
        }
        this.index = 0;
        while (this.index < this.gendynPointSize) {
            this.gendynTimeArray[this.index] = Math.abs(this.randWalk(this.gendynTimeArray[this.index], this.gendynTimeStepSize, this.gendynTimeMirror, true));
            if (this.gendynTimeArray[this.index] < 1.0) {
                this.gendynTimeArray[this.index] = 1.0;
            }
            this.gendynAmpArray[this.index] = this.randWalk(this.gendynAmpArray[this.index], this.gendynAmpStepSize, this.gendynAmpMirror / 2 + 51, false);
            ++this.index;
        }
        this.gendynIntArrayLength = 0.0;
        this.index = 0;
        while (this.index < this.gendynPointSize) {
            this.gendynIntArrayLength += this.gendynTimeArray[this.index];
            ++this.index;
        }
        this.gendynIntArray = new int[(int)this.gendynIntArrayLength];
        this.mgaCounter = 0;
        this.mgaInc = (this.gendynAmpArray[0] - this.gendynAmp0) / this.gendynTimeArray[0];
        this.jindex = 0;
        while (this.jindex < (int)this.gendynTimeArray[0]) {
            switch (this.gendynInterpolation) {
                case 2: {
                    diff = (1.0 - (Math.cos((double)this.jindex / this.gendynTimeArray[0] * 3.14) / 2.0 + 0.5)) * (this.gendynAmpArray[0] - this.gendynAmp0);
                    this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmp0 + diff) / 100.0 * (double)this.gendynAmpGranularity);
                    break;
                }
                case 1: {
                    this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmp0 + this.mgaInc * (double)this.jindex) / 100.0 * (double)this.gendynAmpGranularity);
                    break;
                }
                case 3: {
                    this.gendynIntArray[this.mgaCounter++] = (int)(this.gendynAmp0 / 100.0 * (double)this.gendynAmpGranularity);
                }
            }
            ++this.jindex;
        }
        this.index = 1;
        while (this.index < this.gendynPointSize - 1) {
            this.mgaInc = (this.gendynAmpArray[this.index] - this.gendynAmpArray[this.index - 1]) / this.gendynTimeArray[this.index];
            this.jindex = 0;
            while (this.jindex < (int)this.gendynTimeArray[this.index]) {
                switch (this.gendynInterpolation) {
                    case 2: {
                        diff = (1.0 - (Math.cos((double)this.jindex / this.gendynTimeArray[this.index] * 3.14) / 2.0 + 0.5)) * (this.gendynAmpArray[this.index] - this.gendynAmpArray[this.index - 1]);
                        this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmpArray[this.index - 1] + diff) / 100.0 * (double)this.gendynAmpGranularity);
                        break;
                    }
                    case 1: {
                        this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmpArray[this.index - 1] + this.mgaInc * (double)this.jindex) / 100.0 * (double)this.gendynAmpGranularity);
                        break;
                    }
                    case 3: {
                        this.gendynIntArray[this.mgaCounter++] = (int)(this.gendynAmpArray[this.index - 1] / 100.0 * (double)this.gendynAmpGranularity);
                    }
                }
                ++this.jindex;
            }
            ++this.index;
        }
        this.gendynAmp0 = this.gendynAmpArray[this.gendynPointSize - 1];
        this.gendynIntArrayCounter = 0;
        if (this.pointSizeReset) {
            this.resetPointSize();
        }
        if (this.gendynGranularityUpdate) {
            this.updateGranularity();
        }
    }

    private double randWalk(double prevVal, double stepSize, int mirror, boolean timeWalk) {
        this.rwNewVal = 0.0;
        this.rwNewVal = this.gendynGaussian ? prevVal + this.RandomGenerator.nextGaussian() * stepSize : prevVal + (this.RandomGenerator.nextDouble() * stepSize * 2.0 - stepSize);
        if (timeWalk) {
            if (stepSize == 0.0) {
                this.rwNewVal = prevVal;
            } else {
                while (this.rwNewVal > (double)mirror || this.rwNewVal < 0.0) {
                    if (this.rwNewVal > (double)mirror) {
                        this.rwNewVal = (double)mirror - (this.rwNewVal - (double)mirror);
                    }
                    if (!(this.rwNewVal < 0.0)) continue;
                    this.rwNewVal = this.rwNewVal / 2.0 * -1.0;
                }
            }
            if (this.rwNewVal < 0.0) {
                this.rwNewVal = 0.0;
            }
        } else {
            int negMirror = this.mirrorMax - mirror;
            while (this.rwNewVal > (double)mirror || this.rwNewVal < (double)negMirror) {
                if (this.rwNewVal > (double)mirror) {
                    this.rwNewVal = (double)mirror - (this.rwNewVal - (double)mirror);
                }
                if (!(this.rwNewVal < (double)negMirror)) continue;
                this.rwNewVal = (double)negMirror + ((double)negMirror - this.rwNewVal);
            }
            if (this.rwNewVal < 0.0) {
                this.rwNewVal = 0.0;
            }
        }
        return this.rwNewVal;
    }

    public void setNoiseDensity(int newDensity) {
        this.noiseDensity = newDensity;
    }

    public void setStandardDeviation(double newValue) {
        this.standardDeviation = newValue;
    }

    public void setMean(double newValue) {
        this.mean = newValue;
    }

    public void setWalkStepSize(double val) {
        if (val > 0.0) {
            this.walkStepSize = (float)val;
        } else {
            System.err.println("Walk step size must be greater than zero.");
        }
    }

    public void setWalkMax(double val) {
        if (val > 0.0) {
            this.walkMax = (float)val;
        } else {
            System.err.println("Walk maximum value must be greater than zero.");
        }
    }

    public void setWalkMin(double val) {
        if (val < 0.0) {
            this.walkMin = (float)val;
        } else {
            System.err.println("Walk minimum value must be less than zero.");
        }
    }

    public void setWalkNoiseDensity(int val) {
        if (val > 0) {
            this.walkNoiseDensity = val;
        } else {
            System.err.println("walkNoiseDensity must be greater than zero.");
        }
    }

    public void setWalkVaryDensity(boolean val) {
        this.walkVaryDensity = val;
    }

    public void setWalkNoiseDensityMin(int val) {
        if (val > 0) {
            this.walkNoiseDensityMin = val;
        } else {
            System.err.println("walkNoiseDensityMin must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityMax(int val) {
        if (val > 0) {
            this.walkNoiseDensityMax = val;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityStepSize(int val) {
        if (val > 0) {
            this.walkNoiseDensityStepSize = val;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setGendynTimeMirror(double newVal) {
        if (newVal > 1.0 && newVal <= 100.0) {
            this.gendynTimeMirror = (int)newVal;
        } else {
            System.err.println("GendynTimeMirror must be between 3 and 100, not " + newVal);
        }
    }

    public void setGendynAmpMirror(double newVal) {
        if (newVal > 0.0 && newVal <= 100.0) {
            this.gendynAmpMirror = (int)newVal;
        } else {
            System.err.println("GendynAmpMirror must be between 1 and 100, not " + newVal);
        }
    }

    public double getGendynAmp0() {
        return this.gendynAmp0;
    }

    public int getGendynPointSize() {
        return this.gendynPointSize;
    }

    public void setGendynPointSize(int val) {
        this.pointSizeReset = true;
        this.newPointSize = val;
    }

    private void resetPointSize() {
        this.gendynPointSize = this.newPointSize;
        this.gendynAmpArray = new double[this.gendynPointSize];
        this.gendynTimeArray = new double[this.gendynPointSize];
        for (int i = 0; i < this.gendynPointSize; ++i) {
            this.gendynAmpArray[i] = 50.0;
            this.gendynTimeArray[i] = 30.0;
        }
        if (this.getGendynAmpStepSize() < 3.0) {
            this.setGendynAmpStepSize(3);
        }
        this.pointSizeReset = false;
    }

    public double getGendynAmpArray(int i) {
        return this.gendynAmpArray[i];
    }

    public double getGendynTimeArray(int i) {
        return this.gendynTimeArray[i];
    }

    public double getGendynAmpStepSize() {
        return this.gendynAmpStepSize;
    }

    public void setGendynAmpStepSize(int val) {
        if (val >= 0) {
            this.gendynAmpStepSize = val;
        }
    }

    public double getGendynTimeStepSize() {
        return this.gendynTimeStepSize;
    }

    public void setGendynTimeStepSize(double val) {
        if (val >= 0.0) {
            this.gendynTimeStepSize = val;
        }
    }

    public void setMaxGendynAmpStepSize(int val) {
        if (val >= 0) {
            this.maxGendynAmpStepSize = val;
        }
    }

    public void setMaxGendynTimeStepSize(int val) {
        if (val >= 0) {
            this.maxGendynTimeStepSize = val;
        }
    }

    public void setGendynPrimaryAmpStepSize(int val) {
        if (val >= 0) {
            this.gendynPrimaryAmpStepSize = val;
        }
    }

    public void setGendynPrimaryTimeStepSize(int val) {
        if (val >= 0) {
            this.gendynPrimaryTimeStepSize = val;
        }
    }

    public void setGendynAmpGranularity(int val) {
        this.gendynGranularityUpdate = true;
        this.tempGendynGranularity = val;
    }

    private void updateGranularity() {
        if (this.tempGendynGranularity > 0) {
            this.gendynAmpGranularity = this.tempGendynGranularity;
        }
    }

    public void setGendynPrimaryTimeMirror(int val) {
        if (val >= 0) {
            this.gendynPrimaryTimeMirror = val;
        }
    }

    public void setGendynPrimaryAmpMirror(int val) {
        if (val >= 0) {
            this.gendynPrimaryAmpMirror = val;
        }
    }

    public int getGendynInterpolation() {
        return this.gendynInterpolation;
    }

    public void setGendynInterpolation(int val) {
        this.gendynInterpolation = val;
    }

    public void setGendynGaussian(boolean val) {
        this.gendynGaussian = val;
    }

    static {
        rg = new float[16];
        np = 1;
        nbits = 1;
        numbPoints = 48000;
        nr = numbPoints;
        counter = 0;
    }
}

