/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class ReSample
extends AudioObject {
    private double baseFreq = 0.0;
    private double newFreq = 0.0;
    private boolean noteFreq = true;

    public ReSample(AudioObject ao, double baseFreq) {
        super(ao, "[ReSample]");
        this.baseFreq = baseFreq;
    }

    public void build() {
        if (this.noteFreq) {
            this.newFreq = this.currentNote.getFrequency();
        }
        this.finished = true;
    }

    public int work(float[] buffer) throws AOException {
        double cfm = this.newFreq / this.baseFreq;
        double skip = -1.0 / ((1.0 - cfm) / cfm);
        double remains = 0.0;
        int upSample = 0;
        if (skip < 0.0) {
            skip = -1.0 / skip;
            upSample = 1;
        }
        if (skip == 0.0) {
            upSample = 2;
            skip = 1.0;
        }
        float[] tmpBuf = new float[(int)((double)buffer.length * cfm + 0.5) + 1];
        int ret = this.previous[0].nextWork(tmpBuf);
        float tmp = 0.0f;
        int count = 0;
        int index = 0;
        int i = 0;
        while (true) {
            block9: {
                block10: {
                    block7: {
                        block8: {
                            if (upSample != 0) break block7;
                            if (++index < (int)(skip + remains)) break block8;
                            remains = (skip + remains) % 1.0;
                            index = 0;
                            break block9;
                        }
                        if (count >= buffer.length) break;
                        buffer[count++] = tmpBuf[i];
                        break block10;
                    }
                    if (upSample == 1) {
                        if (skip + remains >= 1.0) {
                            float increment = (tmpBuf[i] - tmp) / (float)(skip + remains);
                            for (int k = 0; k < (int)(skip + remains); ++k) {
                                buffer[count++] = tmp + increment * (float)k;
                                if (count == buffer.length) break;
                            }
                        }
                        if (count == buffer.length) break;
                        buffer[count++] = tmpBuf[i];
                        tmp = tmpBuf[i];
                        remains = (skip + remains) % 1.0;
                    } else {
                        buffer[count++] = tmpBuf[i];
                    }
                }
                if (count == buffer.length) break;
            }
            ++i;
        }
        return buffer.length;
    }
}

