/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class StereoPan
extends AudioObject {
    boolean panSet = false;
    private float pan;
    private int channel = 1;

    public StereoPan(AudioObject ao) {
        super(ao, "[StereoPan]");
        this.pan = 0.5f;
    }

    public StereoPan(AudioObject ao, double pan) {
        super(ao, "[StereoPan]");
        this.panSet = true;
        this.pan = pan < 0.0 ? 0.0f : (pan > 1.0 ? 1.0f : (float)pan);
    }

    public void build() {
        float tmpPan = (float)this.currentNote.getPan();
        if (!this.panSet) {
            this.pan = tmpPan < 0.0f ? 0.0f : (tmpPan > 1.0f ? 1.0f : tmpPan);
        }
        this.channel = 1;
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].work(buffer);
        if (this.channels == 1) {
            return returned;
        }
        for (int i = 0; i < returned; ++i) {
            if (this.channel == 1) {
                if ((double)this.pan > 0.5) {
                    buffer[i] = buffer[i] * (1.0f - (this.pan - 0.5f) * 2.0f);
                }
                this.channel = 2;
                continue;
            }
            if ((double)this.pan < 0.5) {
                buffer[i] = buffer[i] * this.pan * 2.0f;
            }
            this.channel = 1;
        }
        return returned;
    }

    public void setPan(double pan) {
        if (pan >= 0.0 && pan <= 1.0) {
            this.pan = (float)pan;
        }
    }
}

