/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class TapDelay
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;
    private int taps;
    private int sampleDelay;

    public TapDelay(AudioObject ao, int delay, int taps) {
        this(ao, delay, taps, 0.5);
    }

    public TapDelay(AudioObject ao, int delay, int taps, double decay) {
        super(ao, "[Tap Delay]");
        this.finished = false;
        this.decay = (float)decay;
        this.delay = delay;
        this.taps = taps;
    }

    public int work(float[] buffer) throws AOException {
        int i;
        int returned = buffer.length;
        if (!this.inst.finishedNewData && this.inst.getFinished()) {
            returned = this.previous[0].nextWork(buffer);
        }
        float max = 0.0f;
        for (i = 0; i < returned; ++i) {
            for (int k = 1; k <= this.taps; ++k) {
                int tapIndex = this.delayIndex + this.sampleDelay * this.channels * k;
                if (tapIndex >= this.delayLine.length) {
                    tapIndex -= this.delayLine.length;
                }
                int n = tapIndex;
                this.delayLine[n] = this.delayLine[n] + buffer[i] * (this.decay / (float)k);
            }
            int n = i;
            buffer[n] = buffer[n] + this.delayLine[this.delayIndex];
            this.delayLine[this.delayIndex] = 0.0f;
            ++this.delayIndex;
            if (this.delayIndex >= this.delayLine.length) {
                this.delayIndex = 0;
            }
            if (!(max < buffer[i])) continue;
            max = buffer[i];
        }
        if (this.inst.iterations <= 0 - this.delayLine.length) {
            this.finished = true;
        }
        return i;
    }

    public void build() {
        if (this.delayLine == null) {
            this.sampleDelay = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
            this.delayLine = new float[this.sampleDelay * this.channels * this.taps];
            this.delayIndex = 0;
        }
        this.finished = false;
    }
}

