/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Volume
extends AudioObject {
    float mainVolume = 1.0f;
    float volume = 1.0f;
    double linearVolumeValue = 1.0;
    private int returned;
    private int index;
    private float[] tmp;

    public Volume(AudioObject ao) {
        this(ao, 1.0f);
    }

    public Volume(AudioObject ao, double volume) {
        this(ao, (float)volume);
    }

    public Volume(AudioObject ao, float volume) {
        super(ao, "[Volume]");
        this.mainVolume = volume;
    }

    public void build() {
        this.linearVolumeValue = (double)this.currentNote.getDynamic() / 127.0;
        this.volume = (float)(1.0 - Math.log(128.0 - (double)this.currentNote.getDynamic()) * 0.2) * this.mainVolume;
    }

    public int work(float[] buffer) throws AOException {
        this.returned = this.previous[0].nextWork(buffer);
        if (this.inputs == 2) {
            if (this.tmp == null || this.tmp.length != buffer.length) {
                this.tmp = new float[buffer.length];
            } else {
                this.index = 0;
                while (this.index < this.tmp.length) {
                    this.tmp[this.index] = 0.0f;
                    ++this.index;
                }
            }
            if (this.returned != this.previous[1].nextWork(this.tmp)) {
                throw new AOException(this.name, 0);
            }
            this.index = 0;
            while (this.index < this.returned) {
                buffer[this.index] = buffer[this.index] * this.tmp[this.index];
                ++this.index;
            }
        } else {
            this.index = 0;
            while (this.index < this.returned) {
                buffer[this.index] = buffer[this.index] * this.volume;
                ++this.index;
            }
        }
        return this.returned;
    }

    public double getVolume() {
        return this.linearVolumeValue;
    }

    public void setVolume(double volValue) {
        this.linearVolumeValue = volValue;
        this.volume = (float)Math.min(1.0, Math.abs(Math.log(1.0 - volValue) * 0.2));
    }
}

