/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.JMC;
import jm.gui.cpn.JGrandStave;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class JStaveActionHandler
implements JMC,
MouseListener,
MouseMotionListener,
ActionListener {
    private JGrandStave theApp;
    private int selectedNote = -1;
    private boolean topTimeSelected = false;
    private boolean keySelected = false;
    private int clickedPosY;
    private int clickedPosX;
    private int storedPitch = 72;
    private double[] rhythmValues = new double[]{104.0, 103.0, 102.0, 101.5, 101.0, 100.75, 100.5, 100.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0};

    JStaveActionHandler(JGrandStave stave) {
        this.theApp = stave;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Integer tempX;
        if (!this.theApp.editable) {
            return;
        }
        Integer lastX = this.theApp.notePositions.size() < 2 ? new Integer(this.theApp.getTotalBeatWidth()) : (Integer)this.theApp.notePositions.elementAt(this.theApp.notePositions.size() - 2);
        if (e.getX() > lastX + 15 && e.getX() < this.theApp.getTotalBeatWidth() + 50) {
            int newPitch = 85 - (e.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
            int[] blackNotes = new int[]{1, 3, 6, 8, 10};
            boolean white = true;
            for (int k = 0; k < blackNotes.length; ++k) {
                if (newPitch % 12 != blackNotes[k]) continue;
                --newPitch;
            }
            Note n = new Note(newPitch, 1.0);
            Phrase phr = this.theApp.getPhrase();
            phr.addNote(n);
            this.theApp.repaint();
            this.theApp.setCursor(new Cursor(12));
            this.selectedNote = phr.size() - 1;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        } else {
            for (int i = 0; i < this.theApp.notePositions.size(); i += 2) {
                tempX = (Integer)this.theApp.notePositions.elementAt(i);
                Integer tempY = (Integer)this.theApp.notePositions.elementAt(i + 1);
                if (e.getX() <= tempX || e.getX() >= tempX + 15 || e.getY() + this.theApp.staveDelta <= tempY + 22 || e.getY() + this.theApp.staveDelta >= tempY + 35) continue;
                this.theApp.setCursor(new Cursor(13));
                this.selectedNote = i / 2;
                this.clickedPosY = e.getY() + this.theApp.staveDelta;
                this.clickedPosX = e.getX();
                i = this.theApp.notePositions.size();
            }
        }
        if (this.selectedNote < 0) {
            for (int j = 0; j < this.theApp.notePositions.size() - 2; j += 2) {
                tempX = (Integer)this.theApp.notePositions.elementAt(j);
                Integer nextTempX = (Integer)this.theApp.notePositions.elementAt(j + 2);
                if (e.getX() <= tempX + 15 || e.getX() >= nextTempX) continue;
                this.theApp.setCursor(new Cursor(12));
                int newPitch = 85 - (e.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
                int[] blackNotes = new int[]{1, 3, 6, 8, 10};
                boolean white = true;
                for (int k = 0; k < blackNotes.length; ++k) {
                    if (newPitch % 12 != blackNotes[k]) continue;
                    --newPitch;
                }
                Note n = new Note(newPitch, 1.0);
                Phrase phr = this.theApp.getPhrase();
                phr.getNoteList().insertElementAt(n, j / 2 + 1);
                this.theApp.repaint();
                this.selectedNote = j / 2 + 1;
                this.clickedPosY = e.getY() + this.theApp.staveDelta;
                this.clickedPosX = e.getX();
                j = this.theApp.notePositions.size();
            }
        }
        int theSpace = this.theApp.rightMargin + this.theApp.clefWidth + this.theApp.keySigWidth;
        if (e.getX() > theSpace && e.getX() < theSpace + 10) {
            this.theApp.setCursor(new Cursor(13));
            this.topTimeSelected = true;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        }
        int theClefSpace = this.theApp.rightMargin + this.theApp.clefWidth;
        int minKeySpace = 10;
        if (this.theApp.keySigWidth > minKeySpace) {
            minKeySpace = this.theApp.keySigWidth;
        }
        if (e.getX() > theClefSpace - 10 && e.getX() < theClefSpace + minKeySpace) {
            this.theApp.setCursor(new Cursor(13));
            this.keySelected = true;
            this.clickedPosY = e.getY() + this.theApp.staveDelta;
            this.clickedPosX = e.getX();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.theApp.editable) {
            return;
        }
        if (this.selectedNote >= 0) {
            int i;
            int currRVindex;
            int tempPitch;
            double tempRV;
            Phrase phr = this.theApp.getPhrase();
            Note n = phr.getNote(this.selectedNote);
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                n.setPitch(n.getPitch() - 1);
                if (n.getPitch() < this.theApp.getMinPitch()) {
                    n.setPitch(this.theApp.getMinPitch());
                }
                this.clickedPosY += 2;
                this.theApp.repaint();
                this.storedPitch = n.getPitch();
            }
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                n.setPitch(n.getPitch() + 1);
                if (n.getPitch() > this.theApp.getMaxPitch()) {
                    n.setPitch(this.theApp.getMaxPitch());
                }
                this.clickedPosY -= 2;
                this.theApp.repaint();
                this.storedPitch = n.getPitch();
            }
            if (e.getX() > this.clickedPosX + 6) {
                tempRV = n.getRhythmValue();
                tempPitch = n.getPitch();
                if (tempPitch == Integer.MIN_VALUE) {
                    tempRV += 100.0;
                }
                currRVindex = this.rhythmValues.length;
                for (i = 0; i < this.rhythmValues.length - 1; ++i) {
                    if (tempRV != this.rhythmValues[i]) continue;
                    n.setRhythmValue(this.rhythmValues[i + 1]);
                }
                this.clickedPosX = e.getX();
                if (n.getRhythmValue() > 100.0) {
                    n.setPitch(Integer.MIN_VALUE);
                    n.setRhythmValue(n.getRhythmValue() - 100.0);
                    n.setDuration(n.getRhythmValue() * 0.9);
                } else if (tempPitch == Integer.MIN_VALUE) {
                    n.setPitch(this.storedPitch);
                }
                this.theApp.repaint();
            }
            if (e.getX() < this.clickedPosX - 6) {
                tempRV = n.getRhythmValue();
                tempPitch = n.getPitch();
                if (tempPitch == Integer.MIN_VALUE) {
                    tempRV += 100.0;
                }
                currRVindex = 0;
                for (i = 0; i < this.rhythmValues.length; ++i) {
                    if (tempRV != this.rhythmValues[i]) continue;
                    currRVindex = i;
                }
                if (currRVindex > 0) {
                    n.setRhythmValue(this.rhythmValues[currRVindex - 1]);
                    this.clickedPosX = e.getX();
                    if (n.getRhythmValue() > 100.0) {
                        n.setPitch(Integer.MIN_VALUE);
                        n.setRhythmValue(n.getRhythmValue() - 100.0);
                        n.setDuration(n.getRhythmValue() * 0.9);
                    } else if (tempPitch == Integer.MIN_VALUE) {
                        n.setPitch(this.storedPitch);
                    }
                    this.theApp.repaint();
                }
            }
        }
        if (this.topTimeSelected) {
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setMetre(this.theApp.getMetre() + 1.0);
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setMetre(this.theApp.getMetre() - 1.0);
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
        if (this.keySelected) {
            if (e.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() + 1);
                if (this.theApp.getKeySignature() > 7) {
                    this.theApp.setKeySignature(7);
                }
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (e.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() - 1);
                if (this.theApp.getKeySignature() < -7) {
                    this.theApp.setKeySignature(-7);
                }
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.theApp.editable) {
            return;
        }
        for (int i = 0; i < this.theApp.getPhrase().getNoteList().size(); ++i) {
            if (this.theApp.getPhrase().getNote(i).getRhythmValue() != 0.0) continue;
            this.theApp.getPhrase().getNoteList().removeElementAt(i);
        }
        this.theApp.repaint();
        this.theApp.updateChange();
        this.selectedNote = -1;
        this.topTimeSelected = false;
        this.keySelected = false;
        this.theApp.setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent e) {
    }
}

