/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class PhraseViewer
extends Dialog
implements WindowListener {
    private ScrollPane scrollPane = new ScrollPane();
    private TextArea textArea = new TextArea(20, 120);
    private Phrase phrase;
    private Stave stave;
    private DecimalFormat decimalFormat = new DecimalFormat("#####.######");

    public PhraseViewer(Frame parentFrame) {
        super(parentFrame, "Phrase Detail Display", true);
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    private void placeControls() {
        this.scrollPane.add(this.textArea);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
    }

    public void showPhrase(Stave theStave, Phrase thePhrase, int locX, int locY) {
        this.stave = theStave;
        this.phrase = thePhrase;
        this.getPhraseText();
        this.setLocation(locX, locY);
        this.show();
    }

    private void getPhraseText() {
        this.getStaveText();
        this.textArea.append("Phrase has " + this.phrase.size() + " notes.\n");
        this.textArea.append("Tempo " + this.decimalFormat.format(this.phrase.getTempo()));
        this.textArea.append("    Numerator " + this.phrase.getNumerator());
        this.textArea.append("    Denominator " + this.phrase.getDenominator());
        this.textArea.append("\n");
        for (int i = 0; i < this.phrase.size(); ++i) {
            this.getNoteText(this.phrase.getNote(i));
        }
    }

    private void getStaveText() {
        this.textArea.append("Stave " + this.stave.getTitle() + "   Metre " + this.decimalFormat.format(this.stave.getMetre()) + "\n");
    }

    private void getNoteText(Note n) {
        this.textArea.append("Pitch " + n.getPitch());
        this.textArea.append("   Start " + this.decimalFormat.format(n.getSampleStartTime()));
        this.textArea.append("   Rhythm " + this.decimalFormat.format(n.getRhythmValue()));
        this.textArea.append("   Dur " + this.decimalFormat.format(n.getDuration()));
        this.textArea.append("   Offset " + this.decimalFormat.format(n.getOffset()));
        this.textArea.append("   Vol " + n.getDynamic());
        this.textArea.append("\n");
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

