/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Statistics
implements Cloneable,
Serializable {
    private double[] elementData;
    private double largestValue = 0.0;
    private int size;

    public Statistics(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new double[initialCapacity];
    }

    public Statistics() {
        this(100);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            double[] oldData = this.elementData;
            this.elementData = new double[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new double[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public double largestValue() {
        return this.largestValue;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(double value) {
        for (int i = 0; i < this.size; ++i) {
            if (value != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            Statistics stats = (Statistics)super.clone();
            stats.elementData = new double[this.size];
            System.arraycopy(this.elementData, 0, stats.elementData, 0, this.size);
            return stats;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public double[] toArray() {
        double[] result = new double[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public double[] toArray(double[] a) {
        if (a.length < this.size) {
            a = new double[this.size];
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = 0.0;
        }
        return a;
    }

    public double resetLargestValue() {
        this.largestValue = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.get(i) > this.largestValue)) continue;
            this.largestValue = this.get(i);
        }
        return this.largestValue;
    }

    public double get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    public double set(int index, double element) {
        this.rangeCheck(index);
        double oldValue = this.elementData[index];
        this.elementData[index] = element;
        if (oldValue == this.largestValue) {
            this.resetLargestValue();
        } else if (element > this.largestValue) {
            this.largestValue = oldValue;
        }
        return oldValue;
    }

    public boolean add(double stats) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = stats;
        if (stats > this.largestValue) {
            this.largestValue = stats;
        }
        return true;
    }

    public boolean add(double[] stats) {
        this.ensureCapacity(this.size + stats.length);
        for (int i = 0; i < stats.length; ++i) {
            this.elementData[this.size++] = stats[i];
            if (!(stats[i] > this.largestValue)) continue;
            this.largestValue = stats[i];
        }
        return true;
    }

    public void add(int index, double element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
        if (element > this.largestValue) {
            this.largestValue = element;
        }
    }

    public double removeIndex(int index) {
        this.rangeCheck(index);
        double oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0.0;
        return oldValue;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0.0;
        }
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = 0.0;
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeDouble(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new double[arrayLength];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = s.readDouble();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Statistics)) {
            return false;
        }
        Statistics stats = (Statistics)o;
        if (this.size == stats.size()) {
            for (int i = 0; i < this.size; ++i) {
                double s2;
                double s1 = this.get(i);
                if (s1 == (s2 = stats.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean removeValue(double stats) {
        for (int i = 0; i < this.size; ++i) {
            if (stats != this.get(i)) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(this.get(i)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

