/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import jm.gui.graph.Statistics;

public class StatisticsList
implements Cloneable,
Serializable {
    protected transient int modCount = 0;
    private transient Statistics[] elementData;
    private int size;

    public StatisticsList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Statistics[initialCapacity];
    }

    public StatisticsList() {
        this(10);
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Statistics[] oldData = this.elementData;
            this.elementData = new Statistics[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Statistics[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Statistics[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Statistics elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Statistics elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Statistics elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            StatisticsList sl = (StatisticsList)super.clone();
            sl.elementData = new Statistics[this.size];
            System.arraycopy(this.elementData, 0, sl.elementData, 0, this.size);
            sl.modCount = 0;
            return sl;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Statistics[] toArray() {
        Statistics[] result = new Statistics[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public Statistics[] toArray(Statistics[] a) {
        if (a.length < this.size) {
            a = (Statistics[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Statistics get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    public Statistics set(int index, Statistics element) {
        this.rangeCheck(index);
        Statistics oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(Statistics stats) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = stats;
        return true;
    }

    public void add(int index, Statistics element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public Statistics remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        Statistics oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = null;
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new Statistics[arrayLength];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = (Statistics)s.readObject();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsList)) {
            return false;
        }
        StatisticsList sl = (StatisticsList)o;
        if (this.size == sl.size()) {
            for (int i = 0; i < this.size; ++i) {
                Statistics s1 = this.get(i);
                Statistics s2 = sl.get(i);
                if (s1 != null ? s1.equals(s2) : s2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            Statistics stats = this.get(i);
            hashCode = 31 * hashCode + (stats == null ? 0 : stats.hashCode());
        }
        return hashCode;
    }

    public boolean remove(Statistics stats) {
        if (stats == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.get(i) != null) continue;
                this.remove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!stats.equals(this.get(i))) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(this.get(i)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

