/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Histogram
extends Component
implements JMC {
    private Score score;
    private int maxPitchValue;
    private int maxRhythmValue;
    private int maxDynamicValue;
    private int maxPanValue;
    private int[] pitchValues;
    private int[] rhythmValues;
    private int[] dynamicValues;
    private int[] panValues;
    private Font f = new Font("Helvetica", 0, 9);
    private int barWidth = 4;
    private int lableSpace = 24;
    private int type = 0;
    private String title = "Pitch Histogram";
    private int xPos = 0;
    private int yPos = 0;

    public Histogram(Score score) {
        this(score, 0);
    }

    public Histogram(Score score, int type) {
        this(score, type, 0, 0);
    }

    public Histogram(Score score, int type, int xPos, int yPos) {
        this(score, type, xPos, yPos, 200);
    }

    public Histogram(Score score, int type, int xPos, int yPos, int width) {
        this.score = score;
        this.type = type;
        this.xPos = xPos;
        this.yPos = yPos;
        if (type == 1) {
            this.title = "Rhythm Histogram";
        }
        if (type == 2) {
            this.title = "Dynamic Histogram";
        }
        if (type == 3) {
            this.title = "Pan Histogram";
        }
        this.setSize(width, this.barWidth * 127 + this.lableSpace);
        this.analysis();
    }

    private void analysis() {
        this.pitchValues = new int[128];
        this.rhythmValues = new int[66];
        this.dynamicValues = new int[127];
        this.panValues = new int[100];
        this.maxPitchValue = 0;
        this.maxRhythmValue = 0;
        this.maxDynamicValue = 0;
        this.maxPanValue = 0;
        Enumeration enum1 = this.score.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            Enumeration enum2 = part.getPhraseList().elements();
            while (enum2.hasMoreElements()) {
                Phrase phrase = (Phrase)enum2.nextElement();
                Enumeration enum3 = phrase.getNoteList().elements();
                while (enum3.hasMoreElements()) {
                    int val;
                    Note note = (Note)enum3.nextElement();
                    if (note.getPitchType() || note.getPitch() == Integer.MIN_VALUE) continue;
                    int n = note.getPitch();
                    this.pitchValues[n] = this.pitchValues[n] + 1;
                    if (this.pitchValues[note.getPitch()] > this.maxPitchValue) {
                        this.maxPitchValue = this.pitchValues[note.getPitch()];
                    }
                    if ((val = (int)(note.getRhythmValue() / 0.125)) >= this.rhythmValues.length) {
                        val = this.rhythmValues.length - 1;
                    }
                    int n2 = val;
                    this.rhythmValues[n2] = this.rhythmValues[n2] + 1;
                    if (this.rhythmValues[val] > this.maxRhythmValue) {
                        this.maxRhythmValue = this.rhythmValues[val];
                    }
                    int n3 = note.getDynamic();
                    this.dynamicValues[n3] = this.dynamicValues[n3] + 1;
                    if (this.dynamicValues[note.getDynamic()] > this.maxDynamicValue) {
                        this.maxDynamicValue = this.dynamicValues[note.getDynamic()];
                    }
                    int n4 = (int)(note.getPan() * 100.0);
                    this.panValues[n4] = this.panValues[n4] + 1;
                    if (this.panValues[(int)(note.getPan() * 100.0)] <= this.maxPanValue) continue;
                    this.maxPanValue = this.panValues[(int)(note.getPan() * 100.0)];
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setType(int type) {
        this.type = type;
        this.repaint();
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setScore(Score s) {
        this.score = s;
        this.analysis();
        this.repaint();
    }

    public void saveData() {
        FileDialog fd = new FileDialog(new Frame(), "Save histogram data as...", 1);
        fd.show();
        String fileName = fd.getFile();
        if (fileName != null) {
            this.saveDataAs(fd.getDirectory() + fileName);
        }
    }

    public void saveDataAs(String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            String headerText = "Pitch value" + String.valueOf("\t") + "Pitch data" + String.valueOf("\t") + "Rhythm value" + String.valueOf("\t") + "Rhythm data" + String.valueOf("\t") + "Dynamic value" + String.valueOf("\t") + "Dynamic data" + String.valueOf("\t") + "Pan value" + String.valueOf("\t") + "Pan data" + String.valueOf("\n");
            out.write(headerText.getBytes());
            for (int i = 0; i < this.pitchValues.length; ++i) {
                String data = String.valueOf(i) + String.valueOf("\t") + String.valueOf(this.pitchValues[i]);
                if (i < this.rhythmValues.length) {
                    data = data + String.valueOf("\t") + String.valueOf((double)i * 0.125) + String.valueOf("\t") + String.valueOf(this.rhythmValues[i]);
                }
                if (i < this.dynamicValues.length) {
                    data = data + String.valueOf("\t") + String.valueOf(i) + String.valueOf("\t") + String.valueOf(this.dynamicValues[i]);
                }
                if (i < this.panValues.length) {
                    data = data + String.valueOf("\t") + String.valueOf((double)i / 100.0) + String.valueOf("\t") + String.valueOf(this.panValues[i]);
                }
                data = data + String.valueOf("\n");
                out.write(data.getBytes());
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.f);
        FontMetrics fm = g.getFontMetrics(this.f);
        int ascent = fm.getAscent() / 2;
        int maxValue = 0;
        if (this.type == 0) {
            maxValue = this.maxPitchValue;
        } else if (this.type == 1) {
            maxValue = this.maxRhythmValue;
        } else if (this.type == 2) {
            maxValue = this.maxDynamicValue;
        } else if (this.type == 3) {
            maxValue = this.maxPanValue;
        }
        for (int i = 0; i < 5; ++i) {
            g.setColor(Color.green);
            String lString = "" + maxValue / 4 * i;
            g.drawString(lString, this.getSize().width / 5 * i + this.lableSpace - fm.stringWidth(lString) / 2, this.lableSpace - fm.getAscent() / 2);
            g.setColor(Color.gray);
            g.drawLine(this.getSize().width / 5 * i + this.lableSpace, this.lableSpace, this.getSize().width / 5 * i + this.lableSpace, this.getSize().height);
        }
        switch (this.type) {
            case 0: {
                this.paintPitches(g);
                break;
            }
            case 1: {
                this.paintRhythms(g);
                break;
            }
            case 2: {
                this.paintDynamics(g);
                break;
            }
            case 3: {
                this.paintPans(g);
            }
        }
    }

    private void paintPitches(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.f);
        int ascent = fm.getAscent() / 2;
        for (int i = 0; i < 127; ++i) {
            if (i % 12 == 0) {
                g.setColor(Color.red);
            } else if (i % 12 == 4) {
                g.setColor(Color.orange);
            } else if (i % 12 == 7) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.black);
            }
            g.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.pitchValues[i] / (double)this.maxPitchValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 12 == 0) {
                g.setColor(Color.red);
                g.drawString("C" + (i / 12 - 1), 2, i * this.barWidth + ascent + this.lableSpace);
            }
            if (i % 12 == 4) {
                g.setColor(Color.orange);
                g.drawString("E" + (i / 12 - 1), 2, i * this.barWidth + ascent + this.lableSpace);
            }
            if (i % 12 != 7) continue;
            g.setColor(Color.blue);
            g.drawString("G" + (i / 12 - 1), 2, i * this.barWidth + ascent + this.lableSpace);
        }
    }

    private void paintRhythms(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.f);
        int ascent = fm.getAscent();
        for (int i = 1; i < 65; ++i) {
            if (i % 8 == 0) {
                g.setColor(Color.red);
            } else if (i % 8 == 4) {
                g.setColor(Color.orange);
            } else if (i % 8 == 2 || i % 8 == 6) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.black);
            }
            g.fillRect(this.lableSpace, i * this.barWidth * 2 + this.lableSpace, (int)((double)this.rhythmValues[i] / (double)this.maxRhythmValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth * 2 - 1);
            if (i % 8 == 0) {
                g.setColor(Color.red);
                g.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + ascent + this.lableSpace);
            }
            if (i % 8 == 4) {
                g.setColor(Color.orange);
                g.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + ascent + this.lableSpace);
            }
            if (i % 8 != 2 && i % 8 != 6) continue;
            g.setColor(Color.blue);
            g.drawString("" + (double)i / 8.0, 2, i * this.barWidth * 2 + ascent + this.lableSpace);
        }
    }

    private void paintDynamics(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.f);
        int ascent = fm.getAscent() / 2;
        for (int i = 1; i < 127; ++i) {
            if (i % 10 == 0) {
                g.setColor(Color.red);
            } else if (i % 10 == 5) {
                g.setColor(Color.orange);
            } else {
                g.setColor(Color.black);
            }
            g.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.dynamicValues[i] / (double)this.maxDynamicValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 10 == 0) {
                g.setColor(Color.red);
                g.drawString("" + i, 2, i * this.barWidth + ascent + this.lableSpace);
            }
            if (i % 10 != 5) continue;
            g.setColor(Color.orange);
            g.drawString("" + i, 2, i * this.barWidth + ascent + this.lableSpace);
        }
    }

    private void paintPans(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.f);
        int ascent = fm.getAscent() / 2;
        for (int i = 1; i < 100; ++i) {
            if (i % 10 == 0 && i != 50) {
                g.setColor(Color.red);
            } else if (i % 10 == 5 && i != 50) {
                g.setColor(Color.orange);
            } else if (i == 50) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.black);
            }
            g.fillRect(this.lableSpace, i * this.barWidth + this.lableSpace, (int)((double)this.panValues[i] / (double)this.maxPanValue * ((double)this.getSize().width - (double)this.lableSpace)), this.barWidth - 1);
            if (i % 10 == 0 && i != 50) {
                g.setColor(Color.red);
                g.drawString("" + (double)i / 100.0, 2, i * this.barWidth + ascent + this.lableSpace);
                continue;
            }
            if (i % 10 == 5 && i != 50) {
                g.setColor(Color.orange);
                g.drawString("" + (double)i / 100.0, 2, i * this.barWidth + ascent + this.lableSpace);
                continue;
            }
            if (i != 50) continue;
            g.setColor(Color.blue);
            g.drawString("" + (double)i / 100.0, 2, i * this.barWidth + ascent + this.lableSpace);
        }
    }
}

