/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Enumeration;
import jm.gui.show.ShowPanel;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;

public class ShowArea
extends Canvas {
    private int oldX;
    private int maxColours = 8;
    private float[][] theColours = new float[this.maxColours][3];
    private int noteHeight = 5;
    private int w = 2 * this.noteHeight;
    private int ePos = 5 * this.noteHeight;
    private int e = this.ePos + this.noteHeight * 33;
    private int areaHeight = 77 * this.noteHeight;
    private int[] noteOffset = new int[]{0, 0, this.noteHeight, this.noteHeight, this.noteHeight * 2, this.noteHeight * 3, this.noteHeight * 3, this.noteHeight * 4, this.noteHeight * 4, this.noteHeight * 5, this.noteHeight * 5, this.noteHeight * 6};
    private Font font = new Font("Helvetica", 0, 10);
    private ShowPanel sp;
    private double beatWidth;
    private int thinNote = 2;

    public ShowArea(ShowPanel sp) {
        this.sp = sp;
        this.setSize((int)(sp.score.getEndTime() * sp.beatWidth), this.areaHeight);
        for (int i = 0; i < this.maxColours; ++i) {
            this.theColours[i][0] = (float)(Math.random() / (double)this.maxColours / 2.0) + (float)(1.0 / (double)this.maxColours * (double)i);
            this.theColours[i][1] = (float)(Math.random() / (double)this.maxColours) + (float)(1.0 / (double)this.maxColours * (double)i);
        }
    }

    private void reInit() {
        this.w = 2 * this.noteHeight;
        this.ePos = 5 * this.noteHeight;
        this.e = this.ePos + this.noteHeight * 33;
        this.areaHeight = 77 * this.noteHeight;
        this.noteOffset = new int[]{0, 0, this.noteHeight, this.noteHeight, this.noteHeight * 2, this.noteHeight * 3, this.noteHeight * 3, this.noteHeight * 4, this.noteHeight * 4, this.noteHeight * 5, this.noteHeight * 5, this.noteHeight * 6};
        this.setSize(new Dimension(this.getSize().width, this.areaHeight));
        this.sp.updatePanelHeight();
    }

    public int getHeight() {
        return this.areaHeight;
    }

    public void setNoteHeight(int val) {
        this.noteHeight = val;
        this.reInit();
        this.repaint();
    }

    public int getThinNote() {
        return this.thinNote;
    }

    public void setThinNote(int newVal) {
        if (newVal >= 0) {
            this.thinNote = newVal;
        }
        this.repaint();
    }

    public void paint(Graphics offScreenGraphics) {
        offScreenGraphics.setColor(Color.white);
        offScreenGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        offScreenGraphics.setFont(this.font);
        offScreenGraphics.setColor(Color.black);
        this.beatWidth = this.sp.beatWidth;
        int maxWidth = (int)Math.round(this.sp.score.getEndTime() * this.beatWidth);
        offScreenGraphics.drawLine(0, this.e, maxWidth, this.e);
        offScreenGraphics.drawLine(0, this.e - this.w, maxWidth, this.e - this.w);
        offScreenGraphics.drawLine(0, this.e - this.w * 2, maxWidth, this.e - this.w * 2);
        offScreenGraphics.drawLine(0, this.e - this.w * 3, maxWidth, this.e - this.w * 3);
        offScreenGraphics.drawLine(0, this.e - this.w * 4, maxWidth, this.e - this.w * 4);
        offScreenGraphics.drawLine(0, this.e + this.w * 2, maxWidth, this.e + this.w * 2);
        offScreenGraphics.drawLine(0, this.e + this.w * 3, maxWidth, this.e + this.w * 3);
        offScreenGraphics.drawLine(0, this.e + this.w * 4, maxWidth, this.e + this.w * 4);
        offScreenGraphics.drawLine(0, this.e + this.w * 5, maxWidth, this.e + this.w * 5);
        offScreenGraphics.drawLine(0, this.e + this.w * 6, maxWidth, this.e + this.w * 6);
        offScreenGraphics.setColor(Color.lightGray);
        offScreenGraphics.drawLine(0, this.e - this.w * 7, maxWidth, this.e - this.w * 7);
        offScreenGraphics.drawLine(0, this.e - this.w * 8, maxWidth, this.e - this.w * 8);
        offScreenGraphics.drawLine(0, this.e - this.w * 9, maxWidth, this.e - this.w * 9);
        offScreenGraphics.drawLine(0, this.e - this.w * 10, maxWidth, this.e - this.w * 10);
        offScreenGraphics.drawLine(0, this.e - this.w * 11, maxWidth, this.e - this.w * 11);
        offScreenGraphics.drawLine(0, this.e + this.w * 9, maxWidth, this.e + this.w * 9);
        offScreenGraphics.drawLine(0, this.e + this.w * 10, maxWidth, this.e + this.w * 10);
        offScreenGraphics.drawLine(0, this.e + this.w * 11, maxWidth, this.e + this.w * 11);
        offScreenGraphics.drawLine(0, this.e + this.w * 12, maxWidth, this.e + this.w * 12);
        offScreenGraphics.drawLine(0, this.e + this.w * 13, maxWidth, this.e + this.w * 13);
        for (int k = 0; k < maxWidth; k += 10) {
            offScreenGraphics.drawLine(k, this.e + this.w, k + 1, this.e + this.w);
            offScreenGraphics.drawLine(k, this.e - this.w * 5, k + 1, this.e - this.w * 5);
            offScreenGraphics.drawLine(k, this.e - this.w * 6, k + 1, this.e - this.w * 6);
            offScreenGraphics.drawLine(k, this.e - this.w * 12, k + 1, this.e - this.w * 12);
            offScreenGraphics.drawLine(k, this.e - this.w * 13, k + 1, this.e - this.w * 13);
            offScreenGraphics.drawLine(k, this.e - this.w * 14, k + 1, this.e - this.w * 14);
            offScreenGraphics.drawLine(k, this.e - this.w * 15, k + 1, this.e - this.w * 15);
            offScreenGraphics.drawLine(k, this.e - this.w * 16, k + 1, this.e - this.w * 16);
            offScreenGraphics.drawLine(k, this.e - this.w * 17, k + 1, this.e - this.w * 17);
            offScreenGraphics.drawLine(k, this.e - this.w * 18, k + 1, this.e - this.w * 18);
            offScreenGraphics.drawLine(k, this.e + this.w * 7, k + 1, this.e + this.w * 7);
            offScreenGraphics.drawLine(k, this.e + this.w * 8, k + 1, this.e + this.w * 8);
            offScreenGraphics.drawLine(k, this.e + this.w * 14, k + 1, this.e + this.w * 14);
            offScreenGraphics.drawLine(k, this.e + this.w * 15, k + 1, this.e + this.w * 15);
            offScreenGraphics.drawLine(k, this.e + this.w * 16, k + 1, this.e + this.w * 16);
            offScreenGraphics.drawLine(k, this.e + this.w * 17, k + 1, this.e + this.w * 17);
            offScreenGraphics.drawLine(k, this.e + this.w * 18, k + 1, this.e + this.w * 18);
        }
        Enumeration enum1 = this.sp.score.getPartList().elements();
        int i = 0;
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            Enumeration enum2 = part.getPhraseList().elements();
            while (enum2.hasMoreElements()) {
                Phrase phrase = (Phrase)enum2.nextElement();
                Enumeration enum3 = phrase.getNoteList().elements();
                double oldXBeat = phrase.getStartTime();
                int rectLeft = this.oldX = (int)Math.round(oldXBeat * this.beatWidth);
                int rectTop = 100000;
                int rectRight = this.oldX;
                int rectBot = 0;
                while (enum3.hasMoreElements()) {
                    Note aNote = (Note)enum3.nextElement();
                    int currNote = -1;
                    currNote = !aNote.getPitchType() ? aNote.getPitch() : Note.freqToMidiPitch(aNote.getFrequency());
                    if (currNote <= 127 && currNote >= 0) {
                        int octavePixelheight = this.noteHeight * 7;
                        int y = (10 - currNote / 12) * octavePixelheight + this.ePos - this.noteOffset[currNote % 12];
                        int x = (int)Math.round(aNote.getDuration() * this.beatWidth);
                        int xRV = (int)Math.round(aNote.getRhythmValue() * this.beatWidth);
                        if (x < 1) {
                            x = 1;
                        }
                        if (y < rectTop) {
                            rectTop = y;
                        }
                        if (y > rectBot) {
                            rectBot = y;
                        }
                        offScreenGraphics.setColor(Color.getHSBColor(this.theColours[i % this.maxColours][0], this.theColours[i % this.maxColours][1], (float)(0.7 - (double)aNote.getDynamic() * 0.004)));
                        if (!aNote.getPitchType()) {
                            offScreenGraphics.fillRect(this.oldX, y - this.noteHeight + this.thinNote, x, this.noteHeight * 2 - 2 * this.thinNote);
                        } else {
                            int heightOffset = 7;
                            for (int j = this.oldX; j < this.oldX + x - 4; j += 4) {
                                offScreenGraphics.drawLine(j, y - this.noteHeight + heightOffset, j + 2, y - this.noteHeight + heightOffset - 3);
                                offScreenGraphics.drawLine(j + 2, y - this.noteHeight + heightOffset - 3, j + 4, y - this.noteHeight + heightOffset);
                            }
                        }
                        offScreenGraphics.setColor(Color.getHSBColor(this.theColours[i % this.maxColours][0], this.theColours[i % this.maxColours][1], 0.4f));
                        offScreenGraphics.drawRect(this.oldX, y - this.noteHeight + this.thinNote, xRV, this.noteHeight * 2 - 2 * this.thinNote);
                        if (currNote % 12 == 1 || currNote % 12 == 3 || currNote % 12 == 6 || currNote % 12 == 8 || currNote % 12 == 10) {
                            offScreenGraphics.setColor(Color.getHSBColor(this.theColours[i % this.maxColours][0], this.theColours[i % this.maxColours][1], 0.3f));
                            offScreenGraphics.drawString("#", this.oldX - 7, y + 5);
                        }
                    }
                    this.oldX = (int)Math.round((oldXBeat += aNote.getRhythmValue()) * this.beatWidth);
                    rectRight = this.oldX - rectLeft;
                }
                offScreenGraphics.setColor(Color.getHSBColor(this.theColours[i % this.maxColours][0], this.theColours[i % this.maxColours][1], 0.9f));
                offScreenGraphics.drawRect(rectLeft - 1, rectTop - this.noteHeight - 1, rectRight + 1, rectBot - rectTop + this.noteHeight * 2 + 2);
            }
            ++i;
        }
    }
}

