/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class WaveCanvas
extends Canvas {
    public Image image = null;
    protected Graphics g;
    private float[] data;
    private int segmentSize = 0;
    private int resolution = 125;
    private int height = 200;
    private int amplitude = 1;
    private boolean resized = false;
    private Color waveColor = Color.darkGray;
    private Color backgroundColor = Color.white;
    private int sampleStart = 0;
    private int waveSize;
    private boolean fastDraw = false;

    public void setData(float[] data) {
        this.data = data;
        this.segmentSize = data.length;
    }

    public void setResolution(int size) {
        if (size > 0) {
            this.resolution = size;
        }
        this.setFastDraw(true);
        this.repaint();
        this.setFastDraw(false);
        this.repaint();
    }

    public void setHeight(int val) {
        if (val > 0) {
            this.height = val;
        }
        this.setSize(new Dimension(600, this.height + 1));
        this.resized = true;
        this.repaint();
    }

    public void setFastDraw(boolean state) {
        this.fastDraw = state;
    }

    public void setAmplitude(int size) {
        if (size > 0) {
            this.amplitude = size;
        }
        this.repaint();
    }

    public void setWaveSize(int size) {
        this.waveSize = size;
    }

    public void setResized(boolean val) {
        this.resized = val;
        this.setFastDraw(true);
        this.repaint();
        this.setFastDraw(false);
        this.repaint();
    }

    public void toggleColor() {
        if (this.waveColor == Color.darkGray) {
            this.waveColor = Color.green;
            this.backgroundColor = Color.darkGray;
        } else {
            this.waveColor = Color.darkGray;
            this.backgroundColor = Color.white;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.setCursor(new Cursor(3));
        if (this.image == null || this.resized) {
            this.image = this.createImage(this.getSize().width, this.getSize().height);
            this.g = this.image.getGraphics();
            this.resized = false;
        }
        this.clearImage(this.g);
        int h2 = this.height / 2 - 1;
        this.g.setColor(Color.black);
        this.g.drawLine(0, h2, this.getSize().width, h2);
        int xMax = this.getSize().width * this.resolution;
        int dataMax = this.data.length - this.resolution;
        this.g.setColor(this.waveColor);
        if (this.resolution == 1) {
            for (int i = 0; i < xMax && i < dataMax; ++i) {
                float currData = this.data[i];
                this.g.drawLine(i, (int)((float)h2 - currData * (float)h2 * (float)this.amplitude), i, (int)((float)h2 - currData * (float)h2 * (float)this.amplitude));
            }
        } else {
            int xPosition = 0;
            float max = 0.0f;
            float min = 0.0f;
            for (int i = 0; i < xMax && i < dataMax; i += this.resolution) {
                float currData = this.data[i];
                if (this.fastDraw) {
                    this.g.drawLine(xPosition++, (int)((float)h2 - currData * (float)h2 * (float)this.amplitude), xPosition, (int)((float)h2 - currData * (float)h2 * (float)this.amplitude));
                    continue;
                }
                max = 0.0f;
                min = 0.0f;
                for (int j = 0; j < this.resolution; ++j) {
                    if (this.data[i + j] > max) {
                        max = this.data[i + j];
                    }
                    if (!(this.data[i + j] < min)) continue;
                    min = this.data[i + j];
                }
                if (this.resolution > 8) {
                    float drawMax = Math.max(currData, this.data[i + this.resolution]);
                    float drawMin = Math.min(currData, this.data[i + this.resolution]);
                    if (max > 0.0f) {
                        this.g.drawLine(xPosition, (int)((float)h2 - drawMax * (float)h2 * (float)this.amplitude), xPosition, (int)((float)h2 - max * (float)h2 * (float)this.amplitude));
                    }
                    if (min < 0.0f) {
                        this.g.drawLine(xPosition, (int)((float)h2 - drawMin * (float)h2 * (float)this.amplitude), xPosition, (int)((float)h2 - min * (float)h2 * (float)this.amplitude));
                    }
                }
                this.g.drawLine(xPosition++, (int)((float)h2 - currData * (float)h2 * (float)this.amplitude), xPosition, (int)((float)h2 - this.data[i + this.resolution] * (float)h2 * (float)this.amplitude));
            }
        }
        this.g.setColor(Color.lightGray);
        this.g.drawLine(0, this.height, this.getSize().width, this.height);
        graphics.drawImage(this.image, 0, 0, null);
        this.clearImage(this.g);
        this.setCursor(new Cursor(0));
    }

    private void clearImage(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(this.waveColor);
    }
}

