/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.util.Enumeration;
import java.util.Stack;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class MidiSynth
implements JMC,
MetaEventListener {
    private static final int StopType = 47;
    private short m_ppqn;
    private Synthesizer m_synth;
    private Sequence m_seq;
    private Sequencer m_sequencer;
    private float m_currentTempo;
    private float m_masterTempo;
    private Stack m_tempoHistory;
    private double trackTempoRatio = 1.0;
    private double elementTempoRatio = 1.0;
    private String scoreTitle;
    private boolean isPlaying = false;
    private Boolean msCycle = false;
    private Boolean update = false;
    private Score updateScore;

    public MidiSynth() {
        this(480);
    }

    public MidiSynth(short ppqn) {
        this.m_ppqn = ppqn;
        this.m_synth = null;
        this.m_tempoHistory = new Stack();
    }

    protected static MidiEvent createNoteOnEvent(int channel, int pitch, int velocity, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(144 + channel, pitch, velocity);
        MidiEvent evt = new MidiEvent(msg, tick);
        return evt;
    }

    protected static MidiEvent createNoteOffEvent(int channel, int pitch, int velocity, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(128 + channel, pitch, velocity);
        MidiEvent evt = new MidiEvent(msg, tick);
        return evt;
    }

    protected static MidiEvent createProgramChangeEvent(int channel, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(192 + channel, value, 0);
        MidiEvent evt = new MidiEvent(msg, tick);
        return evt;
    }

    protected static MidiEvent createCChangeEvent(int channel, int controlNum, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(176 + channel, controlNum, value);
        MidiEvent evt = new MidiEvent(msg, tick);
        return evt;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void play(Score score) throws InvalidMidiDataException {
        if (null == this.m_sequencer && !this.initSynthesizer()) {
            return;
        }
        this.scoreTitle = score.getTitle();
        this.m_masterTempo = (float)score.getTempo();
        if (null == this.m_seq) {
            this.m_seq = this.scoreToSeq(score);
        } else {
            Track[] tracks = this.m_seq.getTracks();
            int t_len = tracks.length;
            for (int i = 0; i < t_len; ++i) {
                this.m_seq.deleteTrack(tracks[i]);
            }
            this.m_seq = this.scoreToSeq(score);
        }
        if (null != this.m_seq) {
            try {
                this.m_sequencer.open();
            }
            catch (MidiUnavailableException e) {
                System.err.println("MIDI System Unavailable:" + e);
                return;
            }
            this.m_sequencer.setSequence(this.m_seq);
            this.m_sequencer.addMetaEventListener(this);
            this.m_sequencer.setMicrosecondPosition(0L);
            this.m_sequencer.setTempoInBPM(this.m_masterTempo);
            this.m_sequencer.start();
            this.isPlaying = true;
        }
    }

    public void updateSeq(Score score) throws InvalidMidiDataException {
        this.update = true;
        this.updateScore = score;
    }

    public void setCycle(Boolean val) {
        this.msCycle = val;
    }

    private void rePlay() {
        if (null == this.m_sequencer && !this.initSynthesizer()) {
            return;
        }
        if (this.update.booleanValue()) {
            block6: {
                System.out.println("Updating playback sequence");
                try {
                    this.m_seq = this.scoreToSeq(this.updateScore);
                    if (null == this.m_seq) break block6;
                    try {
                        this.m_sequencer.open();
                    }
                    catch (MidiUnavailableException e) {
                        System.err.println("MIDI System Unavailable:" + e);
                        return;
                    }
                    this.m_sequencer.setSequence(this.m_seq);
                }
                catch (InvalidMidiDataException e) {
                    System.err.println("MIDISynth updating sequence error:" + e);
                    return;
                }
            }
            this.update = false;
        }
        this.m_sequencer.setMicrosecondPosition(0L);
        this.m_sequencer.setTempoInBPM(this.m_masterTempo);
        this.m_sequencer.start();
    }

    protected void printSeqInfo(Sequence seq) {
        float type = seq.getDivisionType();
    }

    public void meta(MetaMessage metaEvent) {
        if (metaEvent.getType() == 47) {
            if (this.msCycle.booleanValue()) {
                this.rePlay();
            } else {
                this.stop();
            }
        }
    }

    public void stop() {
        this.msCycle = false;
        this.isPlaying = false;
        if (this.m_sequencer != null & this.m_sequencer.isOpen()) {
            this.m_sequencer.stop();
        }
        System.out.println("jMusic MidiSynth: Stopped JavaSound MIDI playback");
    }

    protected Sequence scoreToSeq(Score score) throws InvalidMidiDataException {
        Sequence sequence = new Sequence(0.0f, this.m_ppqn);
        if (null == sequence) {
            return null;
        }
        this.m_masterTempo = this.m_currentTempo = new Float(score.getTempo()).floatValue();
        Track longestTrack = null;
        double longestTime = 0.0;
        double longestRatio = 1.0;
        Enumeration parts = score.getPartList().elements();
        while (parts.hasMoreElements()) {
            Part inst = (Part)parts.nextElement();
            int currChannel = inst.getChannel();
            if (currChannel > 16) {
                throw new InvalidMidiDataException(inst.getTitle() + " - Invalid Channel Number: " + currChannel);
            }
            this.m_tempoHistory.push(new Float(this.m_currentTempo));
            float tempo = new Float(inst.getTempo()).floatValue();
            if ((double)tempo != -1.0) {
                this.m_currentTempo = tempo;
            } else if ((double)tempo < -1.0) {
                System.out.println("jMusic MidiSynth error: Part TempoEvent (BPM) too low = " + tempo);
            }
            this.trackTempoRatio = this.m_masterTempo / this.m_currentTempo;
            int instrument = inst.getInstrument();
            if (instrument == -1) {
                instrument = 0;
            }
            Enumeration phrases = inst.getPhraseList().elements();
            double max = 0.0;
            double currentTime = 0.0;
            Track currTrack = sequence.createTrack();
            while (phrases.hasMoreElements()) {
                Phrase phrase = (Phrase)phrases.nextElement();
                currentTime = phrase.getStartTime();
                long phraseTick = (long)(currentTime * (double)this.m_ppqn * this.trackTempoRatio);
                if (phrase.getInstrument() != -1) {
                    instrument = phrase.getInstrument();
                }
                MidiEvent evt = MidiSynth.createProgramChangeEvent(currChannel, instrument, phraseTick);
                currTrack.add(evt);
                this.m_tempoHistory.push(new Float(this.m_currentTempo));
                tempo = new Float(phrase.getTempo()).floatValue();
                if ((double)tempo != -1.0) {
                    this.m_currentTempo = tempo;
                }
                this.elementTempoRatio = this.m_masterTempo / this.m_currentTempo;
                double lastPanPosition = -1.0;
                int offSetTime = 0;
                Enumeration notes = phrase.getNoteList().elements();
                while (notes.hasMoreElements()) {
                    Note note = (Note)notes.nextElement();
                    offSetTime = (int)(note.getOffset() * (double)this.m_ppqn * this.elementTempoRatio);
                    int pitch = -1;
                    pitch = !note.getPitchType() ? note.getPitch() : Note.freqToMidiPitch(note.getFrequency());
                    int dynamic = note.getDynamic();
                    if (pitch == Integer.MIN_VALUE) {
                        phraseTick = (long)((double)phraseTick + note.getRhythmValue() * (double)this.m_ppqn * this.elementTempoRatio);
                        continue;
                    }
                    long onTick = phraseTick;
                    if (note.getPan() != lastPanPosition) {
                        evt = MidiSynth.createCChangeEvent(currChannel, 10, (int)(note.getPan() * 127.0), onTick);
                        currTrack.add(evt);
                        lastPanPosition = note.getPan();
                    }
                    evt = MidiSynth.createNoteOnEvent(currChannel, pitch, dynamic, onTick + (long)offSetTime);
                    currTrack.add(evt);
                    long offTick = (long)((double)phraseTick + note.getDuration() * (double)this.m_ppqn * this.elementTempoRatio);
                    evt = MidiSynth.createNoteOffEvent(currChannel, pitch, dynamic, offTick + (long)offSetTime);
                    currTrack.add(evt);
                    phraseTick = (long)((double)phraseTick + note.getRhythmValue() * (double)this.m_ppqn * this.elementTempoRatio);
                    if (!((double)offTick > longestTime)) continue;
                    longestTime = offTick;
                    longestTrack = currTrack;
                }
                Float d = (Float)this.m_tempoHistory.pop();
                this.m_currentTempo = d.floatValue();
            }
            Float d = (Float)this.m_tempoHistory.pop();
            this.m_currentTempo = d.floatValue();
        }
        if (longestTime > 0.0 && longestTrack != null) {
            MetaMessage msg = new MetaMessage();
            byte[] data = new byte[]{};
            msg.setMessage(47, data, 0);
            MidiEvent evt = new MidiEvent(msg, (long)longestTime);
            longestTrack.add(evt);
        }
        return sequence;
    }

    private boolean initSynthesizer() {
        if (null == this.m_synth) {
            try {
                if (MidiSystem.getSequencer() == null) {
                    System.err.println("MidiSystem Sequencer Unavailable");
                    return false;
                }
                this.m_synth = MidiSystem.getSynthesizer();
                this.m_synth.open();
                this.m_sequencer = MidiSystem.getSequencer();
            }
            catch (MidiUnavailableException e) {
                System.err.println("Midi System Unavailable:" + e);
                return false;
            }
        }
        return true;
    }

    public void finalize() {
        this.m_seq = null;
        this.m_sequencer.close();
        this.m_synth.close();
    }
}

