/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import jm.midi.MidiInputListener;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public class RTMidiIn
implements Receiver {
    private int oldStatus;
    private Vector listeners = new Vector();
    private Transmitter trans = null;

    public RTMidiIn() {
        this.init();
    }

    public void addMidiInputListener(MidiInputListener mil) {
        this.listeners.add(mil);
    }

    public void notifyListeners(Event event) {
        Enumeration en = this.listeners.elements();
        while (en.hasMoreElements()) {
            ((MidiInputListener)en.nextElement()).newEvent(event);
        }
    }

    public void send(MidiMessage message, long deltaTime) {
        System.out.println("New MIDI message");
        Event event = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(message.getMessage());
        DataInputStream dis = new DataInputStream(bais);
        try {
            dis.mark(2);
            int status = dis.readUnsignedByte();
            int length = 0;
            if (status < 128) {
                status = this.oldStatus;
                dis.reset();
            }
            if (status >= 255) {
                int type = dis.readUnsignedByte();
                length = MidiUtil.readVarLength(dis);
                event = MidiUtil.createMetaEvent(type);
            } else if (status >= 240) {
                System.out.println("SysEX---");
                length = MidiUtil.readVarLength(dis);
            } else if (status >= 128) {
                short selection = (short)(status / 16);
                short midiChannel = (short)(status - selection * 16);
                VoiceEvt evt = (VoiceEvt)MidiUtil.createVoiceEvent(selection);
                evt.setMidiChannel(midiChannel);
                event = evt;
                if (event == null) {
                    throw new IOException("Read Error");
                }
            }
            if (event != null) {
                event.setTime((int)deltaTime);
                event.read(dis);
            }
            this.oldStatus = status;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.notifyListeners(event);
    }

    public void close() {
        this.trans.close();
    }

    private boolean init() {
        if (this.trans == null) {
            try {
                if (MidiSystem.getReceiver() == null) {
                    System.err.println("MidiSystem Receiver Unavailable");
                    return false;
                }
                MidiDevice.Info[] mdi = MidiSystem.getMidiDeviceInfo();
                for (int i = 0; i < mdi.length; ++i) {
                    System.out.println(mdi[i]);
                }
                this.trans = MidiSystem.getTransmitter();
                this.trans.setReceiver(this);
            }
            catch (MidiUnavailableException e) {
                System.err.println("Midi System Unavailable:" + e);
                return false;
            }
        }
        return true;
    }
}

