/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class KeySig
implements Event {
    private static final short ID = 18;
    private int time;
    private int keySig;
    private int keyQual;

    public KeySig() {
        this.time = 0;
        this.keySig = 0;
        this.keyQual = 0;
    }

    public KeySig(int keySig, int keyQual) {
        this.time = 0;
        this.keySig = keySig;
        this.keyQual = keyQual;
    }

    public KeySig(int time, int keySig, int keyQual) {
        this.time = time;
        this.keySig = keySig;
        this.keyQual = keyQual;
    }

    public int getKeyQuality() {
        return this.keyQual;
    }

    public void setKeyQuality(int keyQuality) {
        this.keyQual = keyQuality;
    }

    public int getKeySig() {
        return this.keySig;
    }

    public void setKeySig(int keySig) {
        this.keySig = keySig;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 18;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte(255);
        dos.writeByte(89);
        dos.writeByte((byte)this.keySig);
        dos.writeByte((byte)this.keyQual);
        return (bytes_out += MidiUtil.writeVarLength(2, dos)) + 4;
    }

    public int read(DataInputStream dis) throws IOException {
        this.keySig = dis.readByte();
        this.keyQual = dis.readUnsignedByte();
        return 2;
    }

    public Event copy() throws CloneNotSupportedException {
        KeySig event;
        try {
            event = (KeySig)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new KeySig();
        }
        return event;
    }

    public void print() {
        System.out.println("KeySig(022):             [time = " + this.time + "][keySig = " + this.keySig + "][keyQual = " + this.keyQual + "]");
    }
}

