/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class PChange
implements VoiceEvt,
Cloneable {
    private final short id = (short)7;
    private short value;
    private short midiChannel;
    private int time;

    public PChange() {
        this.value = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public PChange(short value, short midiChannel, int time) {
        this.value = value;
        this.midiChannel = midiChannel;
        this.time = time;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    public short getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(short midiChannel) {
        this.midiChannel = midiChannel;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 7;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte((byte)(192 + this.midiChannel));
        dos.writeByte((byte)this.value);
        return bytes_out + 2;
    }

    public int read(DataInputStream dis) throws IOException {
        this.value = (short)dis.readUnsignedByte();
        return 1;
    }

    public Event copy() throws CloneNotSupportedException {
        PChange event;
        try {
            event = (PChange)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new PChange();
        }
        return event;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return new String("Program Change(007): [time = " + this.time + "][midiChannel = " + this.midiChannel + "][value = " + this.value + "]");
    }
}

