/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class TimeSig
implements Event {
    public static final short ID = 17;
    private int time;
    private int numerator;
    private int denominator;
    private int metronomePulse;
    private int thirtySecondNotesPerBeat;

    public TimeSig() {
        this(0, 4, 4);
    }

    public TimeSig(int numerator, int denominator) {
        this(0, numerator, denominator);
    }

    public TimeSig(int time, int numerator, int denominator) {
        this.time = time;
        this.numerator = numerator;
        this.denominator = denominator;
        this.metronomePulse = 24;
        this.thirtySecondNotesPerBeat = 32;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int denom) {
        this.denominator = denom;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numer) {
        this.numerator = numer;
    }

    public int getMetronomePulse() {
        return this.metronomePulse;
    }

    public void setMetronomePulse(int metronomePulse) {
        this.metronomePulse = metronomePulse;
    }

    public int getThirtySecondNotesPerBeat() {
        return this.thirtySecondNotesPerBeat;
    }

    public void setThirtySecondNotesPerBeat(int thirtySecondNotesPerBeat) {
        this.thirtySecondNotesPerBeat = thirtySecondNotesPerBeat;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public short getID() {
        return 17;
    }

    public int write(DataOutputStream dos) throws IOException {
        int bytes_out = MidiUtil.writeVarLength(this.time, dos);
        dos.writeByte(255);
        dos.writeByte(88);
        bytes_out += MidiUtil.writeVarLength(4, dos);
        dos.writeByte((byte)this.numerator);
        int num = this.denominator;
        int cnt = 0;
        while (num % 2 == 0) {
            num /= 2;
            ++cnt;
        }
        dos.writeByte((byte)cnt);
        dos.writeByte(24);
        dos.writeByte(8);
        return bytes_out + 6;
    }

    public int read(DataInputStream dis) throws IOException {
        this.numerator = (short)dis.readUnsignedByte();
        short power = (short)dis.readUnsignedByte();
        this.denominator = 1 << power;
        this.metronomePulse = dis.readUnsignedByte();
        this.thirtySecondNotesPerBeat = dis.readUnsignedByte();
        return 4;
    }

    public Event copy() throws CloneNotSupportedException {
        TimeSig event;
        try {
            event = (TimeSig)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
            event = new TimeSig();
        }
        return event;
    }

    public void print() {
        System.out.println("TimeSig(021):             [time = " + this.time + "][numerator = " + this.numerator + "][denominator = " + this.denominator + "]");
    }
}

