/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Part
implements Cloneable,
Serializable,
JMC {
    public static final String DEFAULT_TITLE = "Untitled Part";
    public static final int DEFAULT_INSTRUMENT = 0;
    public static final int DEFAULT_CHANNEL = 0;
    public static final double DEFAULT_TEMPO = -1.0;
    public static final int DEFAULT_KEY_SIGNATURE = Integer.MIN_VALUE;
    public static final int DEFAULT_KEY_QUALITY = Integer.MIN_VALUE;
    public static final int DEFAULT_NUMERATOR = Integer.MIN_VALUE;
    public static final int DEFAULT_DENOMINATOR = Integer.MIN_VALUE;
    public static final double DEFAULT_PAN = 0.5;
    private double pan = 0.5;
    private Vector phraseList;
    private String title = "Unamed Part";
    private int channel;
    private int instrument;
    private double tempo;
    private double[] points = null;
    private long[] time = null;
    private int timeIndex = 0;
    private Score myScore = null;
    private int keySignature;
    private int keyQuality;
    private int numerator;
    private int denominator;

    public Part() {
        this(DEFAULT_TITLE);
    }

    public Part(String title) {
        this(title, 0);
    }

    public Part(int instrument) {
        this("", instrument);
    }

    public Part(String title, int instrument) {
        this(title, instrument, 0);
    }

    public Part(int instrument, int channel) {
        this("", instrument, channel);
    }

    public Part(String title, int instrument, int channel) {
        this.title = title;
        this.phraseList = new Vector();
        if (this.channel > 16) {
            System.err.println(new Exception("jMusic Warning: A MIDI Channel cannot be greater than 16. There can be any number of Audio channels."));
            new Exception().printStackTrace();
        }
        this.channel = channel;
        if (instrument < -1) {
            System.err.println(new Exception("jMusic EXCEPTION: instrument value must be greater than 0"));
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.instrument = instrument;
        this.tempo = -1.0;
        this.keySignature = Integer.MIN_VALUE;
        this.keyQuality = Integer.MIN_VALUE;
        this.numerator = Integer.MIN_VALUE;
        this.denominator = Integer.MIN_VALUE;
    }

    public Part(Phrase phrase) {
        this();
        phrase.setMyPart(this);
        this.addPhrase(phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(String title, int instrument, Phrase phrase) {
        this(title, instrument, 0, phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(String title, int instrument, int channel, Phrase phrase) {
        this(title, instrument, channel);
        phrase.setMyPart(this);
        this.addPhrase(phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(Phrase[] phrases) {
        this();
        this.addPhraseList(phrases);
    }

    public Part(CPhrase cphrase) {
        this();
        this.addCPhrase(cphrase);
    }

    public Part(Phrase phrase, String title) {
        this(title);
        this.addPhrase(phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(Phrase[] phrases, String title) {
        this(title);
        this.addPhraseList(phrases);
    }

    public Part(Phrase phrase, String title, int instrument) {
        this(title, instrument);
        this.addPhrase(phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(Phrase[] phrases, String title, int instrument) {
        this(title, instrument);
        this.addPhraseList(phrases);
    }

    public Part(Phrase phrase, String title, int instrument, int channel) {
        this(title, instrument, channel);
        this.addPhrase(phrase);
        this.setTempo(phrase.getTempo());
    }

    public Part(Phrase[] phrases, String title, int instrument, int channel) {
        this(title, instrument, channel);
        this.addPhraseList(phrases);
    }

    private static void swap(Phrase[] phrases, int i, int j) {
        Phrase temp = phrases[i];
        phrases[i] = phrases[j];
        phrases[j] = temp;
    }

    public Phrase getPhrase(int number) {
        Enumeration enum1 = this.phraseList.elements();
        int counter = 0;
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (counter == number) {
                return phrase;
            }
            ++counter;
        }
        return null;
    }

    public void add(Phrase phrase) {
        this.addPhrase(phrase);
    }

    public void addPhrase(Phrase phrase) {
        phrase.setMyPart(this);
        if (phrase.getAppend()) {
            phrase.setStartTime(this.getEndTime());
        }
        this.phraseList.addElement(phrase);
    }

    public void appendPhrase(Phrase phrase) {
        Phrase newPhrase = phrase.copy();
        newPhrase.setStartTime(this.getEndTime());
        this.addPhrase(newPhrase);
    }

    public void addPhraseList(Phrase[] phraseArray) {
        for (int i = 0; i < phraseArray.length; ++i) {
            if (phraseArray[i].getAppend()) {
                Phrase newPhrase = phraseArray[i].copy();
                newPhrase.setStartTime(this.getEndTime());
                this.addPhrase(newPhrase);
                continue;
            }
            this.addPhrase(phraseArray[i]);
        }
    }

    public void removePhrase(int phraseNumb) {
        Vector vct = this.phraseList;
        try {
            vct.removeElement(vct.elementAt(phraseNumb));
        }
        catch (RuntimeException re) {
            System.err.println("The Phrase index to be deleted must be within the part.");
        }
    }

    public void removePhrase(Phrase phrase) {
        this.phraseList.removeElement(phrase);
    }

    public void removeLastPhrase() {
        Vector vct = this.phraseList;
        vct.removeElement(vct.lastElement());
    }

    public void removeAllPhrases() {
        this.phraseList.removeAllElements();
    }

    public Vector getPhraseList() {
        return this.phraseList;
    }

    public void setPhraseList(Vector newPhraseList) {
        this.phraseList = newPhraseList;
    }

    public Phrase[] getPhraseArray() {
        Vector vct = this.phraseList;
        Phrase[] phraseArray = new Phrase[vct.size()];
        for (int i = 0; i < phraseArray.length; ++i) {
            phraseArray[i] = (Phrase)vct.elementAt(i);
        }
        return phraseArray;
    }

    public void addCPhrase(CPhrase cphrase) {
        if (cphrase.getAppend()) {
            cphrase.setStartTime(this.getEndTime());
        }
        Enumeration enum1 = cphrase.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phr = (Phrase)enum1.nextElement();
            this.addPhrase(phr);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int instrument) {
        this.instrument = instrument;
    }

    public void setProgChg(int program) {
        this.instrument = program;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int newSig) {
        this.keySignature = newSig;
    }

    public int getKeyQuality() {
        return this.keyQuality;
    }

    public void setKeyQuality(int newQual) {
        this.keyQuality = newQual;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int num) {
        this.numerator = num;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int dem) {
        this.denominator = dem;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            phrase.setPan(pan);
        }
    }

    public Score getMyScore() {
        return this.myScore;
    }

    public void setMyScore(Score scr) {
        this.myScore = scr;
    }

    public Part copy() {
        Part i = new Part();
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase oldPhrase = (Phrase)enum1.nextElement();
            i.addPhrase(oldPhrase.copy());
        }
        this.copyAttributes(i);
        return i;
    }

    private void copyAttributes(Part i) {
        i.setInstrument(this.getInstrument());
        i.setChannel(this.getChannel());
        i.setTitle(this.getTitle() + " copy");
        i.setTempo(this.tempo);
        i.setPoints(this.points);
        i.setTime(this.time);
        i.setTimeIndex(this.timeIndex);
        i.setMyScore(this.getMyScore());
    }

    public Part copy(double startLoc, double endLoc) {
        Vector<Phrase> tempVect = new Vector<Phrase>();
        Part cp = new Part();
        this.copyAttributes(cp);
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase ph = (Phrase)enum1.nextElement();
            if (!(ph.getStartTime() < endLoc) || !(ph.getEndTime() > startLoc)) continue;
            tempVect.addElement(ph.copy(startLoc, endLoc));
        }
        cp.setPhraseList(tempVect);
        return cp;
    }

    public Part copy(double startLoc, double endLoc, boolean trimmed, boolean truncated, boolean relativeStartLoc) {
        Part cp = new Part();
        this.copyAttributes(cp);
        Vector<Phrase> tempVect = new Vector<Phrase>();
        cp.setMyScore(this.getMyScore());
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase ph = (Phrase)enum1.nextElement();
            double startTime = ph.getStartTime();
            if (!(startTime < endLoc) || !(ph.getEndTime() > startLoc)) continue;
            Phrase cpy = ph.copy(startLoc, endLoc, trimmed, truncated, false);
            double newStartTime = 0.0;
            if (newStartTime < 0.0) {
                newStartTime = 0.0;
            }
            if (relativeStartLoc) {
                newStartTime += startLoc;
            }
            cpy.setStartTime(newStartTime);
            tempVect.addElement(cpy);
        }
        cp.setPhraseList(tempVect);
        return cp;
    }

    public double getEndTime() {
        double endTime = 0.0;
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase nextPhr = (Phrase)enum1.nextElement();
            double phraseEnd = nextPhr.getEndTime();
            if (!(phraseEnd > endTime)) continue;
            endTime = phraseEnd;
        }
        return endTime;
    }

    public String toString() {
        String partData = new String("----- jMusic PART: '" + this.title + "' contains " + this.size() + " phrases.  -----" + '\n');
        partData = partData + "Channel = " + this.channel + '\n';
        partData = partData + "Instrument = " + this.instrument + '\n';
        if (this.tempo > 0.0) {
            partData = partData + "Part Tempo = " + this.tempo + '\n';
        }
        Enumeration enum1 = this.phraseList.elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            partData = partData + phrase.toString() + '\n';
        }
        return partData;
    }

    public void empty() {
        this.phraseList.removeAllElements();
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.phraseList.size();
    }

    public int getSize() {
        return this.phraseList.size();
    }

    public void clean() {
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (phrase.getInstrument() == this.instrument) {
                phrase.setInstrument(-1);
            }
            if (phrase.getNoteList().size() != 0) continue;
            this.removePhrase(phrase);
        }
    }

    public int getHighestPitch() {
        int max = 0;
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (phrase.getHighestPitch() <= max) continue;
            max = phrase.getHighestPitch();
        }
        return max;
    }

    public int getLowestPitch() {
        int min = 127;
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (phrase.getLowestPitch() >= min) continue;
            min = phrase.getLowestPitch();
        }
        return min;
    }

    public double getLongestRhythmValue() {
        double max = 0.0;
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (!(phrase.getLongestRhythmValue() > max)) continue;
            max = phrase.getLongestRhythmValue();
        }
        return max;
    }

    public double getShortestRhythmValue() {
        double min = 1000.0;
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            if (!(phrase.getShortestRhythmValue() < min)) continue;
            min = phrase.getShortestRhythmValue();
        }
        return min;
    }

    public void setDynamic(int dyn) {
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            phrase.setDynamic(dyn);
        }
    }

    public void setPitch(int val) {
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            phrase.setPitch(val);
        }
    }

    public void setRhythmValue(double val) {
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            phrase.setRhythmValue(val);
        }
    }

    public void setDuration(double val) {
        Enumeration enum1 = this.getPhraseList().elements();
        while (enum1.hasMoreElements()) {
            Phrase phrase = (Phrase)enum1.nextElement();
            phrase.setDuration(val);
        }
    }

    public void setPoints(double[] p) {
        this.points = p;
    }

    public double getPoint() {
        return this.points[this.timeIndex];
    }

    public long getTime() {
        return this.time[this.timeIndex++];
    }

    public void setTime(long[] t) {
        this.time = t;
    }

    public int getTimeIndex() {
        return this.timeIndex;
    }

    public void setTimeIndex(int index) {
        this.timeIndex = index;
    }

    public void addNote(Note n, double startTime) {
        Phrase phrase = new Phrase("Generated by Part.addNote()", startTime);
        phrase.addNote(n);
        this.addPhrase(phrase);
    }

    public Phrase createPhrase() {
        Phrase p = new Phrase();
        this.addPhrase(p);
        return p;
    }

    public void setLength(double newLength) {
        this.setRhythmValue(newLength);
        this.setDuration(newLength * 0.9);
    }

    public void sort() {
        Phrase[] arr = this.getPhraseArray();
        this.quickSort(arr, 0, arr.length - 1);
        this.phraseList.removeAllElements();
        this.phraseList.ensureCapacity(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            this.phraseList.add(arr[i]);
        }
    }

    private void quickSort(Phrase[] phrases, int left, int right) {
        if (left >= right) {
            return;
        }
        Part.swap(phrases, left, (int)(Math.random() * (double)(right - left)) + left);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (!(phrases[i].getStartTime() <= phrases[left].getStartTime())) continue;
            Part.swap(phrases, ++last, i);
        }
        Part.swap(phrases, left, last);
        this.quickSort(phrases, left, last - 1);
        this.quickSort(phrases, last + 1, right);
    }
}

