/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Alignment;
import jm.music.data.Anchoring;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Rest;

public class Phrase
implements JMC,
Cloneable,
Serializable {
    public static final double MIN_START_TIME = 0.0;
    public static final double DEFAULT_START_TIME = 0.0;
    public static final String DEFAULT_TITLE = "Untitled Phrase";
    public static final int DEFAULT_INSTRUMENT = -1;
    public static final boolean DEFAULT_APPEND = false;
    public static final double DEFAULT_TEMPO = -1.0;
    public static final double DEFAULT_PAN = 0.5;
    private double pan = 0.5;
    public static final int DEFAULT_NUMERATOR = 4;
    public static final int DEFAULT_DENOMINATOR = 4;
    private Vector noteList;
    private String title = "Unnamed Phrase";
    private Position position;
    private int instrument;
    private double tempo;
    private boolean append = false;
    private Phrase linkedPhrase;
    private int numerator;
    private int denominator;
    private Part myPart = null;
    private boolean mute = false;

    public Phrase() {
        this(0.0);
        this.append = true;
    }

    public Phrase(double startTime) {
        this(startTime, -1);
    }

    public Phrase(double startTime, int instrument) {
        this(DEFAULT_TITLE, startTime, instrument);
    }

    public Phrase(String title) {
        this(title, 0.0);
        this.append = true;
    }

    public Phrase(String title, double startTime) {
        this(title, startTime, -1);
    }

    public Phrase(String title, double startTime, int instrument) {
        this(title, startTime, instrument, false);
    }

    public Phrase(String title, double startTime, int instrument, boolean append) {
        this.title = title;
        this.position = new Position(startTime, this);
        this.append = append;
        if (instrument < -1) {
            System.err.println(new Exception("jMusic EXCEPTION: instrument value must be greater than 0"));
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.instrument = instrument;
        this.noteList = new Vector();
        this.numerator = 4;
        this.denominator = 4;
        this.tempo = -1.0;
    }

    public Phrase(Note note) {
        this();
        this.addNote(note);
    }

    public Phrase(Note[] notes) {
        this();
        this.addNoteList(notes);
    }

    public Phrase(Note note, String title) {
        this(title);
        this.addNote(note);
    }

    public Phrase(Note[] notes, String title) {
        this(title);
        this.addNoteList(notes);
    }

    public Phrase(Note note, double startTime) {
        this(note);
        this.setStartTime(startTime);
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int value) {
        this.instrument = value;
    }

    public void addNote(Note note) {
        note.setMyPhrase(this);
        this.noteList.addElement(note);
    }

    public void addNote(int pitch, double rv) {
        Note note = new Note(pitch, rv);
        this.addNote(note);
    }

    public void add(Note note) {
        this.addNote(note);
    }

    public void addRest(Rest newRest) {
        newRest.setMyPhrase(this);
        this.noteList.addElement(newRest);
    }

    public void addNoteList(Note[] notes) {
        for (int i = 0; i < notes.length; ++i) {
            this.addNote(notes[i]);
        }
    }

    public void addNoteList(Vector noteVector, boolean append) {
        Enumeration enum1 = noteVector.elements();
        if (!append) {
            this.noteList.removeAllElements();
        }
        while (enum1.hasMoreElements()) {
            try {
                Note note = (Note)enum1.nextElement();
                this.addNote(note);
            }
            catch (RuntimeException re) {
                System.err.println("The vector passed to this method must contain Notes only!");
            }
        }
    }

    public void addNoteList(Note[] noteArray, boolean append) {
        if (!append) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < noteArray.length; ++i) {
            this.addNote(noteArray[i]);
        }
    }

    public void addNoteList(int[] pitchArray, double rhythmValue) {
        double[] rvArray = new double[pitchArray.length];
        for (int i = 0; i < rvArray.length; ++i) {
            rvArray[i] = rhythmValue;
        }
        this.addNoteList(pitchArray, rvArray);
    }

    public void addNoteList(int[] pitchArray, double rhythmValue, int dynamic) {
        double[] rvArray = new double[pitchArray.length];
        int[] dynArray = new int[pitchArray.length];
        for (int i = 0; i < rvArray.length; ++i) {
            rvArray[i] = rhythmValue;
            dynArray[i] = dynamic;
        }
        this.addNoteList(pitchArray, rvArray, dynArray);
    }

    public void addNoteList(double[] freqArray, double rhythmValue) {
        double[] rvArray = new double[freqArray.length];
        for (int i = 0; i < rvArray.length; ++i) {
            rvArray[i] = rhythmValue;
        }
        this.addNoteList(freqArray, rvArray);
    }

    public void addNoteList(int[] pitchArray, double[] rhythmArray) {
        int[] dynamic = new int[pitchArray.length];
        for (int i = 0; i < pitchArray.length; ++i) {
            dynamic[i] = 85;
        }
        this.addNoteList(pitchArray, rhythmArray, dynamic);
    }

    public void addNoteList(double[] freqArray, double[] rhythmArray) {
        int[] dynamic = new int[freqArray.length];
        for (int i = 0; i < freqArray.length; ++i) {
            dynamic[i] = 85;
        }
        this.addNoteList(freqArray, rhythmArray, dynamic);
    }

    public void addNoteList(int[] pitchArray, double[] rhythmArray, int[] dynamic) {
        this.addNoteList(pitchArray, rhythmArray, dynamic, true);
    }

    public void addNoteList(double[] freqArray, double[] rhythmArray, int[] dynamic) {
        this.addNoteList(freqArray, rhythmArray, dynamic, true);
    }

    public void addNoteList(int[] pitchArray, double[] rhythmArray, int[] dynamic, boolean append) {
        if (!append) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < pitchArray.length; ++i) {
            try {
                Note knote = new Note(pitchArray[i], rhythmArray[i], dynamic[i]);
                this.addNote(knote);
                continue;
            }
            catch (RuntimeException re) {
                System.err.println("You must enter arrays of even length");
            }
        }
    }

    public void addNoteList(double[] freqArray, double[] rhythmArray, int[] dynamic, boolean append) {
        if (!append) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < freqArray.length; ++i) {
            try {
                Note knote = new Note(freqArray[i], rhythmArray[i], dynamic[i]);
                this.addNote(knote);
                continue;
            }
            catch (RuntimeException re) {
                System.err.println("jMusic Phrase error: You must enter arrays of even length");
            }
        }
    }

    public void addNoteList(double[] pitchAndRhythmArray) {
        for (int i = 0; i < pitchAndRhythmArray.length; i += 2) {
            try {
                Note knote = new Note((int)pitchAndRhythmArray[i], pitchAndRhythmArray[i + 1]);
                this.addNote(knote);
                continue;
            }
            catch (RuntimeException re) {
                System.err.println("Error adding note list: Possibly the wrong number of values in the pitch and rhythm array.");
            }
        }
    }

    public void addNoteList(int pitch, double[] rhythms) {
        for (int i = 0; i < rhythms.length; ++i) {
            this.addNote(new Note(pitch, rhythms[i]));
        }
    }

    public void addNoteList(double frequency, double[] rhythms) {
        for (int i = 0; i < rhythms.length; ++i) {
            this.addNote(new Note(frequency, rhythms[i]));
        }
    }

    public void addChord(int[] pitches, double rv) {
        for (int i = 0; i < pitches.length - 1; ++i) {
            Note n = new Note(pitches[i], 0.0);
            n.setDuration(rv * 0.9);
            this.addNote(n);
        }
        this.addNote(pitches[pitches.length - 1], rv);
    }

    public int[] getPitchArray() {
        Note[] notes = this.getNoteArray();
        int[] pitches = new int[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            pitches[i] = notes[i].getPitch();
        }
        return pitches;
    }

    public double[] getRhythmArray() {
        Note[] notes = this.getNoteArray();
        double[] rhythms = new double[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            rhythms[i] = notes[i].getRhythmValue();
        }
        return rhythms;
    }

    public int[] getDynamicArray() {
        Note[] notes = this.getNoteArray();
        int[] dynamics = new int[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            dynamics[i] = notes[i].getPitch();
        }
        return dynamics;
    }

    public void removeNote(int noteNumb) {
        Vector vct = this.noteList;
        try {
            vct.removeElement(vct.elementAt(noteNumb));
        }
        catch (RuntimeException re) {
            System.err.println("Note index to be deleted must be within the phrase.");
        }
    }

    public void removeNote(Note note) {
        this.noteList.removeElement(note);
    }

    public void removeLastNote() {
        Vector vct = this.noteList;
        vct.removeElementAt(vct.size() - 1);
    }

    public Vector getNoteList() {
        return this.noteList;
    }

    public void setNoteList(Vector newNoteList) {
        this.noteList = newNoteList;
    }

    public Note[] getNoteArray() {
        Vector vct = this.noteList;
        Note[] noteArray = new Note[vct.size()];
        for (int i = 0; i < noteArray.length; ++i) {
            noteArray[i] = (Note)vct.elementAt(i);
        }
        return noteArray;
    }

    public double getStartTime() {
        return this.position.getStartTime();
    }

    public void setStartTime(double startTime) {
        if (startTime >= 0.0) {
            this.position.setStartTime(startTime);
            this.setAppend(false);
        } else {
            System.err.println("Error setting phrase start time value: You must enter values greater than 0.0");
        }
    }

    public boolean attemptAnchoringTo(Phrase anchor, Alignment alignment, double offset) {
        Position newPosition = new Position(anchor.position, alignment, offset, this);
        if (newPosition.getStartTime() < 0.0) {
            return false;
        }
        this.position = newPosition;
        return true;
    }

    public Anchoring getAnchoring() {
        return this.position.getAnchoring();
    }

    public double getEndTime() {
        double tempStartTime;
        double endTime = tempStartTime = this.getStartTime() < 0.0 ? 0.0 : this.getStartTime();
        Enumeration enum1 = this.noteList.elements();
        while (enum1.hasMoreElements()) {
            Note nextNote = (Note)enum1.nextElement();
            endTime += nextNote.getRhythmValue();
        }
        return endTime;
    }

    final double getTotalDuration() {
        double cumulativeLength = 0.0;
        Enumeration enum1 = this.noteList.elements();
        while (enum1.hasMoreElements()) {
            Note nextNote = (Note)enum1.nextElement();
            cumulativeLength += nextNote.getRhythmValue();
        }
        return cumulativeLength;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public Phrase getLinkedPhrase() {
        return this.linkedPhrase;
    }

    public void setLinkedPhrase(Phrase link) {
        this.linkedPhrase = link;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
        Enumeration enum1 = this.noteList.elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            note.setPan(pan);
        }
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double newTempo) {
        this.tempo = newTempo;
    }

    public Note getNote(int number) {
        Enumeration enum1 = this.noteList.elements();
        int counter = 0;
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            if (counter == number) {
                return note;
            }
            ++counter;
        }
        return null;
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.noteList.size();
    }

    public int getSize() {
        return this.noteList.size();
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int num) {
        this.numerator = num;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int dem) {
        this.denominator = dem;
    }

    public Part getMyPart() {
        return this.myPart;
    }

    public void setMyPart(Part part) {
        this.myPart = part;
    }

    public Phrase copy() {
        Phrase phr = new Phrase();
        this.copyAttributes(phr);
        Enumeration enum1 = this.noteList.elements();
        while (enum1.hasMoreElements()) {
            phr.addNote(((Note)enum1.nextElement()).copy());
        }
        return phr;
    }

    private void copyAttributes(Phrase phr) {
        phr.position = this.position.copy(phr);
        phr.setTitle(this.title + " copy");
        phr.setInstrument(this.instrument);
        phr.setAppend(this.append);
        phr.setPan(this.pan);
        phr.setLinkedPhrase(this.linkedPhrase);
        phr.setMyPart(this.getMyPart());
        phr.setTempo(this.tempo);
        phr.setNumerator(this.numerator);
        phr.setDenominator(this.denominator);
    }

    public Phrase copy(double startLoc, double endLoc) {
        Phrase phr = this.copy(startLoc, endLoc, true);
        return phr;
    }

    public Phrase copy(double startLoc, double endLoc, boolean requireNoteStart) {
        if (startLoc >= endLoc || endLoc < this.getStartTime()) {
            return null;
        }
        Phrase tempPhr = new Phrase(0.0);
        this.copyAttributes(tempPhr);
        double beatCounter = this.getStartTime();
        if (beatCounter < 0.0) {
            beatCounter = 0.0;
        }
        if (startLoc < beatCounter) {
            Note r = new Note(Integer.MIN_VALUE, beatCounter - startLoc);
            tempPhr.addNote(r);
            endLoc += beatCounter - startLoc;
        }
        for (int i = 0; i < this.size(); ++i) {
            Note n;
            if (beatCounter < startLoc) {
                if (beatCounter + this.getNote(i).getRhythmValue() > startLoc && beatCounter + this.getNote(i).getRhythmValue() <= endLoc) {
                    if (requireNoteStart) {
                        n = new Note(Integer.MIN_VALUE, beatCounter + this.getNote(i).getRhythmValue() - startLoc);
                        tempPhr.addNote(n);
                    } else if (!this.getNote(i).getPitchType()) {
                        n = new Note(this.getNote(i).getPitch(), beatCounter + this.getNote(i).getRhythmValue() - startLoc, this.getNote(i).getDynamic());
                        tempPhr.addNote(n);
                    } else {
                        n = new Note(this.getNote(i).getFrequency(), beatCounter + this.getNote(i).getRhythmValue() - startLoc, this.getNote(i).getDynamic());
                        tempPhr.addNote(n);
                    }
                }
                if (beatCounter + this.getNote(i).getRhythmValue() > endLoc) {
                    if (requireNoteStart) {
                        n = new Note(Integer.MIN_VALUE, beatCounter + this.getNote(i).getRhythmValue() - startLoc, this.getNote(i).getDynamic());
                        tempPhr.addNote(n);
                    } else if (!this.getNote(i).getPitchType()) {
                        n = new Note(this.getNote(i).getPitch(), beatCounter + endLoc - startLoc, this.getNote(i).getDynamic());
                        tempPhr.addNote(n);
                    } else {
                        n = new Note(this.getNote(i).getPitch(), beatCounter + endLoc - startLoc, this.getNote(i).getDynamic());
                        tempPhr.addNote(n);
                    }
                }
            }
            if (beatCounter >= startLoc && beatCounter < endLoc) {
                if (beatCounter + this.getNote(i).getRhythmValue() <= endLoc) {
                    tempPhr.addNote(this.getNote(i));
                } else {
                    n = new Note(this.getNote(i).getPitch(), endLoc - beatCounter, this.getNote(i).getDynamic());
                    tempPhr.addNote(n);
                }
            }
            beatCounter += this.getNote(i).getRhythmValue();
        }
        if (beatCounter < endLoc) {
            Note r = new Note(Integer.MIN_VALUE, endLoc - beatCounter);
            tempPhr.addNote(r);
        }
        return tempPhr;
    }

    public Phrase copy(double startLoc, double endLoc, boolean trimmed, boolean truncated, boolean startTimeShifts) {
        Note r;
        if (startLoc >= endLoc || endLoc < this.getStartTime()) {
            System.out.println("invalid arguments in Phrase.copy");
            return null;
        }
        Phrase tempPhr = new Phrase("", startLoc, this.instrument);
        tempPhr.setAppend(this.append);
        tempPhr.setPan(this.pan);
        tempPhr.setLinkedPhrase(this.linkedPhrase);
        tempPhr.setMyPart(this.getMyPart());
        double beatCounter = this.getStartTime();
        if (beatCounter < 0.0) {
            beatCounter = 0.0;
        }
        Enumeration noteEnum = this.getNoteList().elements();
        while (startLoc > beatCounter && noteEnum.hasMoreElements()) {
            Note n = (Note)noteEnum.nextElement();
            beatCounter += n.getRhythmValue();
        }
        if (startLoc < beatCounter) {
            Note r2;
            if (beatCounter < endLoc) {
                if (startTimeShifts) {
                    tempPhr.setStartTime(beatCounter + this.getStartTime());
                } else {
                    r2 = new Note(Integer.MIN_VALUE, beatCounter - startLoc);
                    tempPhr.addNote(r2);
                }
            } else {
                r2 = new Note(Integer.MIN_VALUE, endLoc - startLoc);
                tempPhr.addNote(r2);
                return tempPhr;
            }
        }
        double addedCounter = 0.0;
        while (noteEnum.hasMoreElements() && beatCounter < endLoc) {
            Note n = ((Note)noteEnum.nextElement()).copy();
            if (n.getRhythmValue() + beatCounter > endLoc && trimmed) {
                n.setRhythmValue(endLoc - beatCounter, truncated);
            }
            tempPhr.addNote(n);
            addedCounter += n.getRhythmValue();
            beatCounter += n.getRhythmValue();
        }
        if (beatCounter < endLoc) {
            r = new Note(Integer.MIN_VALUE, endLoc - beatCounter);
            tempPhr.addNote(r);
        } else if (addedCounter == 0.0) {
            r = new Note(Integer.MIN_VALUE, endLoc - startLoc);
            tempPhr.addNote(r);
        }
        return tempPhr;
    }

    public Phrase copy(int highestPitch, int lowestPitch) {
        if (lowestPitch >= highestPitch) {
            System.err.println("jMusic Phrase copy error: lowset pitch is not lower than highest pitch");
            System.exit(0);
        }
        Phrase phr = new Phrase(this.title + " copy");
        phr.position = this.position.copy(phr);
        phr.setInstrument(this.instrument);
        phr.setAppend(this.append);
        phr.setPan(this.pan);
        phr.setLinkedPhrase(this.linkedPhrase);
        phr.setMyPart(this.getMyPart());
        Enumeration enum1 = this.noteList.elements();
        while (enum1.hasMoreElements()) {
            Note n = ((Note)enum1.nextElement()).copy();
            if (n.getPitch() > highestPitch && n.getPitch() < lowestPitch) {
                n.setPitch(Integer.MIN_VALUE);
            }
            phr.addNote(n);
        }
        return phr;
    }

    public String toString() {
        String phraseData = new String("-------- jMusic PHRASE: '" + this.title + "' contains " + this.size() + " notes.  Start time: " + this.getStartTime() + " --------" + '\n');
        if (this.tempo > 0.0) {
            phraseData = phraseData + "Phrase Tempo = " + this.tempo + '\n';
        }
        Enumeration enum1 = this.getNoteList().elements();
        boolean counter = false;
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            phraseData = phraseData + note.toString() + '\n';
        }
        return phraseData;
    }

    public void empty() {
        this.noteList.removeAllElements();
    }

    public Phrase alias() {
        Phrase phr = new Phrase(this.title + " alias", this.getStartTime(), this.instrument);
        phr.setTempo(this.tempo);
        phr.setAppend(this.append);
        phr.noteList = this.noteList;
        return phr;
    }

    public int getHighestPitch() {
        int max = -1;
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            if (note.getPitchType() || note.getPitch() <= max) continue;
            max = note.getPitch();
        }
        return max;
    }

    public int getLowestPitch() {
        int min = 128;
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            if (note.getPitchType() || note.getPitch() >= min || note.getPitch() < 0) continue;
            min = note.getPitch();
        }
        return min;
    }

    public double getLongestRhythmValue() {
        double max = 0.0;
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            if (!(note.getRhythmValue() > max)) continue;
            max = note.getRhythmValue();
        }
        return max;
    }

    public double getShortestRhythmValue() {
        double min = 1000.0;
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            if (!(note.getRhythmValue() < min)) continue;
            min = note.getRhythmValue();
        }
        return min;
    }

    public void setDynamic(int dyn) {
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            note.setDynamic(dyn);
        }
    }

    public void setPitch(int val) {
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            note.setPitch(val);
        }
    }

    public void setRhythmValue(double val) {
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            note.setRhythmValue(val);
        }
    }

    public void setDuration(double val) {
        Enumeration enum1 = this.getNoteList().elements();
        while (enum1.hasMoreElements()) {
            Note note = (Note)enum1.nextElement();
            note.setDuration(val);
        }
    }

    public double getBeatLength() {
        return this.getEndTime();
    }

    public Note createNote() {
        Note n = new Note();
        this.addNote(n);
        return n;
    }

    public void setNote(Note n, int index) {
        if (index >= this.getSize()) {
            System.out.println("jMusic error: Phrase setNote index is too large.");
            return;
        }
        this.noteList.removeElementAt(index);
        this.noteList.insertElementAt(n, index);
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setMute(boolean state) {
        this.mute = state;
    }

    public void setLength(double newLength) {
        this.setRhythmValue(newLength);
        this.setDuration(newLength * 0.9);
    }

    public double getNoteStartTime(int noteIndex) {
        if (noteIndex >= this.size()) {
            return -1.0;
        }
        double startLoc = this.getStartTime();
        for (int i = 0; i < noteIndex; ++i) {
            startLoc += this.getNote(i).getRhythmValue();
        }
        return startLoc;
    }

    private final class Position
    implements Serializable {
        private final Phrase phrase;
        private double startTime = 0.0;
        private boolean isAbsolute = false;
        private Position anchor;
        private Alignment alignment = Alignment.AFTER;
        private double offset;

        private Position(double startTime, Phrase phrase2) {
            this.isAbsolute = true;
            this.startTime = startTime;
            this.phrase = phrase2;
        }

        private Position(Position anchor, Alignment alignment, double offset, Phrase phrase2) {
            this.isAbsolute = false;
            this.anchor = anchor;
            this.alignment = alignment;
            this.offset = offset;
            this.phrase = phrase2;
        }

        private final Anchoring getAnchoring() {
            if (this.isAbsolute) {
                return null;
            }
            return new Anchoring(this.anchor.phrase, this.alignment, this.offset);
        }

        private final double getStartTime() {
            if (this.isAbsolute) {
                return this.startTime;
            }
            return this.alignment.determineStartTime(this.phrase.getTotalDuration(), this.anchor.getStartTime(), this.anchor.getEndTime()) + this.offset;
        }

        private final void setStartTime(double startTime) {
            this.isAbsolute = true;
            this.startTime = startTime;
        }

        private final double getEndTime() {
            return this.phrase.getEndTime();
        }

        private final Position copy(Phrase newCopy) {
            return this.isAbsolute ? new Position(this.startTime, newCopy) : new Position(this.anchor, this.alignment, this.offset, newCopy);
        }
    }
}

