/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;

public class Score
implements JMC,
Cloneable,
Serializable {
    public static final String DEFAULT_TITLE = "Untitled Score";
    public static final double DEFAULT_TEMPO = 60.0;
    public static final int DEFAULT_KEY_SIGNATURE = 0;
    public static final int DEFAULT_KEY_QUALITY = 0;
    public static final int DEFAULT_NUMERATOR = 4;
    public static final int DEFAULT_DENOMINATOR = 4;
    private String title = "Unnamed Score";
    private Vector partList;
    private double tempo;
    private int keySignature;
    private int keyQuality;
    private int numerator;
    private int denominator;

    public Score() {
        this(DEFAULT_TITLE);
    }

    public Score(String title) {
        this(title, 60.0);
    }

    public Score(double tempo) {
        this(DEFAULT_TITLE, tempo);
    }

    public Score(String title, double tempo) {
        this.title = title;
        this.tempo = tempo;
        this.partList = new Vector();
        this.keySignature = 0;
        this.keyQuality = 0;
        this.numerator = 4;
        this.denominator = 4;
    }

    public Score(Part part) {
        this();
        this.tempo = part.getTempo() > 0.0 ? part.getTempo() : this.tempo;
        this.addPart(part);
    }

    public Score(String title, double tempo, Part part) {
        this(title, tempo);
        this.addPart(part);
    }

    public Score(Part[] parts) {
        this();
        this.addPartList(parts);
    }

    public Score(Part part, String title) {
        this(title, part.getTempo());
        this.addPart(part);
    }

    public Score(Part[] parts, String title) {
        this(title);
        this.addPartList(parts);
    }

    public Score(Part part, String title, double tempo) {
        this(title, tempo);
        this.addPart(part);
    }

    public Score(Part[] parts, String title, double tempo) {
        this(title, tempo);
        this.addPartList(parts);
    }

    public void add(Part part) {
        this.addPart(part);
    }

    public void addPart(Part part) {
        part.setMyScore(this);
        this.partList.addElement(part);
    }

    public void insertPart(Part part, int index) throws ArrayIndexOutOfBoundsException {
        this.partList.insertElementAt(part, index);
        part.setMyScore(this);
    }

    public void addPartList(Part[] partArray) {
        for (int i = 0; i < partArray.length; ++i) {
            this.addPart(partArray[i]);
        }
    }

    public void removePart(int partNumb) {
        Vector vct = this.partList;
        try {
            vct.removeElement(vct.elementAt(partNumb));
        }
        catch (RuntimeException re) {
            System.err.println("The Part index to be deleted must be within the score.");
        }
    }

    public void removePart(Part part) {
        this.partList.removeElement(part);
    }

    public void removeLastPart() {
        Vector vct = this.partList;
        vct.removeElement(vct.lastElement());
    }

    public void removeAllParts() {
        this.partList.removeAllElements();
    }

    public Vector getPartList() {
        return this.partList;
    }

    public Part[] getPartArray() {
        Vector vct = (Vector)this.partList.clone();
        Part[] partArray = new Part[vct.size()];
        for (int i = 0; i < partArray.length; ++i) {
            partArray[i] = (Part)vct.elementAt(i);
        }
        return partArray;
    }

    public Part getPart(String title) {
        Enumeration enum1 = this.partList.elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (!part.getTitle().equalsIgnoreCase(title)) continue;
            return part;
        }
        return null;
    }

    public Part getPart(int number) {
        Enumeration enum1 = this.partList.elements();
        int counter = 0;
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (counter == number) {
                return part;
            }
            ++counter;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int newSig) {
        this.keySignature = newSig;
    }

    public int getKeyQuality() {
        return this.keyQuality;
    }

    public void setKeyQuality(int newQual) {
        this.keyQuality = newQual;
    }

    public void setTimeSignature(int num, int dem) {
        this.numerator = num;
        this.denominator = dem;
    }

    public Point getTimeSignature() {
        return new Point(this.numerator, this.denominator);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int num) {
        this.numerator = num;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int dem) {
        this.denominator = dem;
    }

    public Score copy() {
        Score newScore = new Score(this.title + " copy");
        newScore.setTempo(this.tempo);
        newScore.setTimeSignature(this.numerator, this.denominator);
        Enumeration enum1 = this.partList.elements();
        while (enum1.hasMoreElements()) {
            Part oldPart = (Part)enum1.nextElement();
            newScore.addPart(oldPart.copy());
        }
        return newScore;
    }

    public Score copy(double startTime, double endTime) {
        Score score = this.copy();
        score.removeAllParts();
        score.setTempo(this.tempo);
        score.setTimeSignature(this.numerator, this.denominator);
        int scoresize = this.size();
        for (int i = 0; i < scoresize; ++i) {
            score.addPart(this.getPart(i).copy(startTime, endTime));
        }
        return score;
    }

    public double getEndTime() {
        double endTime = 0.0;
        Enumeration enum1 = this.partList.elements();
        while (enum1.hasMoreElements()) {
            Part nextPart = (Part)enum1.nextElement();
            double partEnd = nextPart.getEndTime();
            if (!(partEnd > endTime)) continue;
            endTime = partEnd;
        }
        return endTime;
    }

    public String toString() {
        String scoreData = new String("***** jMusic SCORE: '" + this.title + "' contains " + this.size() + " parts. ****" + '\n');
        scoreData = scoreData + "Score Tempo = " + this.tempo + " bpm" + '\n';
        Enumeration enum1 = this.partList.elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            scoreData = scoreData + part.toString() + '\n';
        }
        return scoreData;
    }

    public void empty() {
        this.empty(false);
    }

    public void empty(boolean nullObjects) {
        if (nullObjects) {
            Enumeration enum1 = this.getPartList().elements();
            while (enum1.hasMoreElements()) {
                Part part = (Part)enum1.nextElement();
                Enumeration enum2 = part.getPhraseList().elements();
                while (enum2.hasMoreElements()) {
                    Phrase phrase = (Phrase)enum2.nextElement();
                    Enumeration enum3 = part.getPhraseList().elements();
                    while (enum3.hasMoreElements()) {
                        Note note = (Note)enum3.nextElement();
                        note = null;
                    }
                    phrase = null;
                }
                Object var3_3 = null;
            }
        }
        this.partList.removeAllElements();
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.partList.size();
    }

    public int getSize() {
        return this.partList.size();
    }

    public void clean() {
        Enumeration enum1 = this.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            part.clean();
            if (part.getPhraseList().size() != 0) continue;
            this.removePart(part);
        }
    }

    public int getHighestPitch() {
        int max = 0;
        Enumeration enum1 = this.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (part.getHighestPitch() <= max) continue;
            max = part.getHighestPitch();
        }
        return max;
    }

    public int getLowestPitch() {
        int min = 127;
        Enumeration enum1 = this.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (part.getLowestPitch() >= min) continue;
            min = part.getLowestPitch();
        }
        return min;
    }

    public double getLongestRhythmValue() {
        double max = 0.0;
        Enumeration enum1 = this.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (!(part.getLongestRhythmValue() > max)) continue;
            max = part.getLongestRhythmValue();
        }
        return max;
    }

    public double getShortestRhythmValue() {
        double min = 1000.0;
        Enumeration enum1 = this.getPartList().elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            if (!(part.getShortestRhythmValue() < min)) continue;
            min = part.getShortestRhythmValue();
        }
        return min;
    }

    public void setPan(double pan) {
        Enumeration enum1 = this.partList.elements();
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            part.setPan(pan);
        }
    }

    public Part createPart() {
        Part p = new Part();
        this.addPart(p);
        return p;
    }
}

