/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Random;

public final class Prob {
    private static final Random RNG = new Random();

    private Prob() {
    }

    public static final int gaussianPitch(int meanPitch, int stdDeviation) {
        long nextPitch;
        while ((nextPitch = Math.round(RNG.nextGaussian() * (double)stdDeviation + (double)meanPitch)) < 0L || nextPitch > 127L) {
        }
        return (int)nextPitch;
    }

    public static final double gaussianFrequency(double meanFrequency, double stdDeviation) {
        double nextFrequency;
        while ((nextFrequency = RNG.nextGaussian() * stdDeviation + meanFrequency) < 1.0E-17) {
        }
        return nextFrequency;
    }

    public static final double gaussianRhythmValue(double meanRV, double stdDev, double granularity) {
        double nextRV;
        do {
            nextRV = RNG.nextGaussian() * stdDev + meanRV;
            nextRV /= granularity;
            nextRV = Math.round(nextRV);
        } while ((nextRV *= granularity) < 0.0 || nextRV > Double.MAX_VALUE);
        return nextRV;
    }

    public static final int gaussianDynamic(int meanDynamic, int stdDeviation) {
        long nextDynamic;
        while ((nextDynamic = Math.round(RNG.nextGaussian() * (double)stdDeviation + (double)meanDynamic)) < 0L || nextDynamic > 127L) {
        }
        return (int)nextDynamic;
    }

    public static final double gaussianPan(double meanPan, double stdDeviation) {
        return Prob.gaussianPan(meanPan, stdDeviation, 1.0);
    }

    public static final double gaussianPan(double meanPan, double stdDeviation, double maxPan) {
        long nextPan;
        double d = maxPan = maxPan >= 0.0 ? maxPan : 0.0;
        while ((double)(nextPan = Math.round(RNG.nextGaussian() * stdDeviation + meanPan)) < 0.0 || (double)nextPan > maxPan) {
        }
        return (int)nextPan;
    }
}

