/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.ga.Recombiner;

public class OnePointCrossover
extends Recombiner {
    private static final int ROUNDS = 10;
    private static final int ELITISM_CONSTANT = 2;

    public Phrase[] recombine(Phrase[] population, double[] fitness, double initialLength, int initialSize, int beatsPerBar) {
        Phrase[] returnPop;
        Phrase[] phraseArray = returnPop = population.length - 2 >= 0 ? new Phrase[population.length - 2] : new Phrase[]{};
        if (returnPop.length > 1) {
            for (int i = 1; i < returnPop.length; i += 2) {
                int numOfMothersBars;
                int father = this.selectTournamentVictor(fitness, -1);
                int mother = this.selectTournamentVictor(fitness, father);
                int numOfFathersBars = (int)population[father].getEndTime() / beatsPerBar;
                int numOfBars = numOfFathersBars > (numOfMothersBars = (int)population[mother].getEndTime() / beatsPerBar) ? numOfMothersBars : numOfFathersBars;
                int crossoverBar = 0;
                while (crossoverBar < (int)(initialLength / (double)beatsPerBar) + 1) {
                    crossoverBar = (int)(Math.random() * (double)numOfBars);
                }
                returnPop[i - 1] = this.crossover(crossoverBar, population[father], population[mother], true, beatsPerBar);
                returnPop[i] = this.crossover(crossoverBar, population[father], population[mother], false, beatsPerBar);
            }
        }
        if ((long)((int)((double)returnPop.length / 2.0)) != Math.round((double)returnPop.length / 2.0)) {
            int numOfMothersBars;
            int father = this.selectTournamentVictor(fitness, -1);
            int mother = this.selectTournamentVictor(fitness, father);
            int numOfFathersBars = (int)population[father].getEndTime() / beatsPerBar;
            int numOfBars = numOfFathersBars > (numOfMothersBars = (int)population[mother].getEndTime() / beatsPerBar) ? numOfMothersBars : numOfFathersBars;
            int crossoverBar = (int)(Math.random() * (double)numOfBars);
            returnPop[returnPop.length - 1] = this.crossover(crossoverBar, population[father], population[mother], true, beatsPerBar);
        }
        return returnPop;
    }

    private int selectTournamentVictor(double[] fitness, int pastVictor) {
        int champion = pastVictor;
        while (champion == pastVictor) {
            champion = (int)(Math.random() * (double)fitness.length);
        }
        for (int j = 0; j < 10; ++j) {
            int challenger = champion;
            while (challenger == champion || challenger == pastVictor) {
                challenger = (int)(Math.random() * (double)fitness.length);
            }
            if (!(fitness[challenger] > fitness[champion])) continue;
            return challenger;
        }
        return champion;
    }

    private Phrase crossover(int crossoverBar, Phrase mother, Phrase father, boolean isFatherFirst, int beatsPerBar) {
        double currentRhythmValue;
        Phrase returnPhrase = new Phrase();
        Phrase currentPhrase = isFatherFirst ? father : mother;
        int currentNote = 0;
        while (returnPhrase.getEndTime() + currentPhrase.getNote(currentNote).getRhythmValue() < (double)(crossoverBar * beatsPerBar)) {
            returnPhrase.addNote(currentPhrase.getNote(currentNote++).copy());
        }
        double rhythmValue = (double)(crossoverBar * beatsPerBar) - returnPhrase.getEndTime();
        returnPhrase.addNote(new Note(currentPhrase.getNote(currentNote).getPitch(), (double)(crossoverBar * beatsPerBar) - returnPhrase.getEndTime()));
        currentNote = -1;
        currentPhrase = isFatherFirst ? mother : father;
        for (currentRhythmValue = 0.0; currentRhythmValue <= (double)(crossoverBar * beatsPerBar); currentRhythmValue += currentPhrase.getNote(++currentNote).getRhythmValue()) {
        }
        returnPhrase.addNote(new Note(currentPhrase.getNote(currentNote++).getPitch(), currentRhythmValue - (double)(crossoverBar * beatsPerBar)));
        while (currentNote < currentPhrase.size()) {
            returnPhrase.addNote(currentPhrase.getNote(currentNote++));
        }
        return returnPhrase;
    }
}

