package com.extjs.gxt.ui.client;

import java.util.ArrayList;
import java.util.List;

public class PartFactory {
  private static List<PartProvider> providers = new ArrayList<PartProvider>();

  @SuppressWarnings("unchecked")
  public static <X> X createPart(String partId) {
    for (PartProvider p : providers) {
      Object part = p.createPart(partId);
      if (part != null) {
        return (X)part;
      }
    }
    throw new RuntimeException("part not found: " + partId);
  }
  
  public static void registerProvider(PartProvider provider) {
    providers.add(provider);
  }
  
  public static void unregisterProvider(PartProvider provider) {
    providers.remove(provider);
  }
}
