/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.event;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel.TreeNode;
import com.google.gwt.user.client.Event;

@SuppressWarnings("unchecked")
public class TreePanelEvent<M extends ModelData> extends BoxComponentEvent {

  private M parent;
  private M child;
  private M item;
  private TreeStore<M> store;
  private TreeNode node;
  private TreePanel<M> treePanel;

  public TreePanelEvent(TreePanel tree) {
    super(tree);
    this.treePanel = tree;
  }

  public TreePanelEvent(TreePanel tree, Event event) {
    super(tree, event);
    this.treePanel = tree;
  }

  public TreePanelEvent(TreePanel tree, M item) {
    this(tree);
    setItem(item);
  }

  public TreePanel<M> getTreePanel() {
    return treePanel;
  }

  public void setTreePanel(TreePanel<M> treePanel) {
    this.treePanel = treePanel;
  }

  public ModelData getChild() {
    return child;
  }

  public ModelData getItem() {
    return item;
  }

  public TreeNode getNode() {
    return node;
  }

  public ModelData getParent() {
    return parent;
  }

  public TreeStore getStore() {
    return store;
  }

  public void setChild(M child) {
    this.child = child;
  }

  public void setItem(M item) {
    this.item = item;
  }

  public void setNode(TreeNode node) {
    this.node = node;
  }

  public void setParent(M parent) {
    this.parent = parent;
  }

  public void setStore(TreeStore store) {
    this.store = store;
  }

}
