/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget.grid;

import java.util.Map;

import com.extjs.gxt.ui.client.data.ModelData;

/**
 * Calculates the value of a summary column.
 *
 * @param <N> the number type
 */
public abstract class SummaryType<N extends Number> {

  public static final SummaryType<Double> SUM = new SummaryType<Double>() {
    @Override
    public Double render(Object v, ModelData m, String field, Map<String, Object> data) {
      if (v == null) {
        v = 0d;
      }
      return ((Double) v) + ((Number) m.get(field)).doubleValue();
    }
  };

  public static final SummaryType<Double> AVG = new SummaryType<Double>() {
    @Override
    public Double render(Object v, ModelData m, String field, Map<String, Object> data) {
      Integer count = (Integer) data.get(field + "count");
      if (count == null) {
        count = new Integer(0);
      }
      int i = count.intValue();
      i++;
      data.put(field + "count", i);

      Double total = (Double) data.get(field + "total");
      if (total == null) total = 0d;
      total += ((Number) m.get(field)).doubleValue();
      data.put(field + "total", total);

      return total == 0 ? 0 : total / i;
    }
  };

  public static final SummaryType<Integer> COUNT = new SummaryType<Integer>() {
    @Override
    public Integer render(Object v, ModelData m, String field, Map<String, Object> data) {
      Integer count = (Integer) data.get(field + "count");
      if (count == null) {
        count = new Integer(0);
      }
      int i = count.intValue();
      i++;
      data.put(field + "count", i);
      return i;
    }
  };

  /**
   * Returns the value for a summary calculation.
   * 
   * @param v the value
   * @param m the containing model
   * @param field the field name
   * @param data the set of data
   * @return the calculated value
   */
  public abstract N render(Object v, ModelData m, String field, Map<String, Object> data);

}
