/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget.treegrid;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;

@SuppressWarnings("unchecked")
public class TreeGridSelectionModel<M extends ModelData> extends GridSelectionModel<M> {
  
  protected TreeGrid tree;
  protected TreeStore<M> treeStore;
  
  @Override
  public void bindGrid(Grid grid) {
    super.bindGrid(grid);
    tree = (TreeGrid)grid;
    treeStore = tree.getTreeStore();
  }
  
  @Override
  protected void handleMouseDown(GridEvent<M> e) {
    super.handleMouseDown(e);
  }
  
  
  @Override
  protected void onKeyLeft(GridEvent<M> ce) {
    if (lastSelected == null) {
      return;
    }
    if (!tree.isLeaf(lastSelected) && tree.isExpanded(lastSelected)) {
      tree.setExpanded(lastSelected, false);
    } else if (treeStore.getParent(lastSelected) != null) {
      doSingleSelect(treeStore.getParent(lastSelected), false);
    }
  }
  @Override
  protected void onKeyRight(GridEvent<M> e) {
    if (lastSelected == null) {
      return;
    }
    if (!tree.isLeaf(lastSelected)) {
      if (!tree.isExpanded(lastSelected)) {
        tree.setExpanded(lastSelected, true);
      }
    }
  }
}
