/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget.treegrid;

import java.util.List;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.tree.Tree.Joint;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid.TreeNode;
import com.google.gwt.user.client.Element;

@SuppressWarnings("unchecked")
public class TreeGridView extends GridView {

  protected TreeGrid tree;
  protected TreeStore treeStore;

  public TreeGridView() {
    setRowSelectorDepth(20);
  }
  
  public void collapse(TreeNode node) {
    ModelData p = node.m;
    ModelData lc = treeStore.getLastChild(p);
    
    int start = ds.indexOf(p);
    int end = ds.indexOf(lc);
    
    for (int i = end; i > start; i--) {
      ds.remove(grid.getStore().getAt(i));
    }
    tree.refresh(node.m);
  }
  
  public void expand(TreeNode node) {
    ModelData p = node.m;
    List<ModelData> children = treeStore.getChildren(p);
    int idx = ds.indexOf(p);
    
    ds.insert(children, idx + 1);
    
    for (ModelData child : children) {
      TreeNode cn = tree.findNode(child);
      if (cn.isExpanded()) {
        expand(cn);
      }
    }
    tree.refresh(node.m);
  }
  
  public Element getJointElement(TreeNode node) {
    Element row = getRowElement(node);
    if (row != null) {
      return El.fly(row).selectNode(".x-ftree2-joint").dom;
    }
    return null;
  }
  
  public native String getTemplate(String id, String text, String iconStyle,
      boolean checked, int joint, int level) /*-{
    var j = "";
    switch (joint) {
      case(1):
       j = "x-ftree2-joint-plus";
       break;
       case(2):
       j = "x-ftree2-joint-minus";
       break;

    }
    var s = '';
    if (iconStyle && iconStyle.indexOf('.') != -1) {
      s = '<img src=' + iconStyle + '></img>';
      iconStyle = '';
    }

    return ['<div id=' + id + ' class="x-tree-item x-ftree2-arrows">',
              '<div class="x-ftree2-node x-ftree2-collapsed">',
              '<table cellspacing="0" cellpadding="0" style="table-layout: fixed"><tr>',
              '<td style="width: ' + (level * 18) + '"></td>',
              '<td class="x-ftree2-joint ' + j + '"></td>',
              '' + (!checked ? '' : '<td class="x-ftree2-check"><div class="my-tree-notchecked"></div></td>'),
              '<td class="x-ftree2-icon ' + iconStyle + '">' + s + '</td>',
              '<td class="x-ftree2-text">' + text + '</td>',
              '</tr></table>',
              '</div>',
              '<div class="x-ftree2-el-ct" style="display: none"/></div>',
            '</div>'].join("");
  }-*/;

  public void onIconStyleChange(TreeNode node, String iconStyle) {
    El iconEl = El.fly(getRowElement(node)).selectNode(".x-ftree2-icon");
    if (iconStyle != null) {
      iconEl.setStyleAttribute("display", "");
      iconEl.setStyleName("x-ftree2-icon " + iconStyle);
    } else {
      iconEl.setStyleAttribute("display", "none");
    }
  }
  
  public void onJointChange(TreeNode node, Joint joint) {
    Element jointEl = getJointElement(node);
    switch (joint) {
      case NONE:
        jointEl.setClassName("x-ftree2-joint");
        break;
      case EXPANDED:
        jointEl.setClassName("x-ftree2-joint x-ftree2-joint-minus");
        break;
      case COLLAPSED:
        jointEl.setClassName("x-ftree2-joint x-ftree2-joint-plus");
        break;
    }
  }

  protected Element getRowElement(TreeNode node) {
    return getRow(ds.indexOf(node.m)).cast();
  }

  @Override
  protected void init(Grid grid) {
    super.init(grid);
    tree = (TreeGrid) grid;
    treeStore = tree.getTreeStore();
  }

}
