/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget.treepanel;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseObservable;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.widget.Component;

public class BaseView<M extends ModelData> extends BaseObservable {

  protected Component component;
  protected Store<M> store;
  protected StoreListener<M> listener;

  public void bind(Component component, Store<M> store) {
    this.component = component;
    this.store = store;

    initListeners();
    
    bindStore(store);
  }

  protected void initListeners() {
    listener = new StoreListener<M>() {

      @Override
      public void storeAdd(StoreEvent<M> se) {
        onAdd(se);
      }

      @Override
      public void storeBeforeDataChanged(StoreEvent<M> se) {
        onBeforeDataChanged(se);
      }

      @Override
      public void storeClear(StoreEvent<M> se) {
        onClear(se);
      }

      @Override
      public void storeDataChanged(StoreEvent<M> se) {
        onDataChanged(se);
      }

      @Override
      public void storeFilter(StoreEvent<M> se) {
        onDataChanged(se);
      }

      @Override
      public void storeRemove(StoreEvent<M> se) {
        onRemove(se);
      }

      @Override
      public void storeUpdate(StoreEvent<M> se) {
        onUpdate(store, se.getModel());
      }
    };
  }

  protected void onRemove(StoreEvent<M> se) {

  }

  protected void onAdd(StoreEvent<M> se) {

  }

  protected void onUpdate(Store<M> store2, M model) {

  }

  protected void onDataChanged(StoreEvent<M> se) {

  }

  protected void onClear(StoreEvent<M> se) {

  }

  protected void onBeforeDataChanged(StoreEvent<M> se) {

  }

  protected void bindStore(Store<M> store) {
    this.store = store;
  }

}
