/*
 * Ext GWT - Ext for GWT
 * Copyright(c) 2007, 2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget.treepanel;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.TreePanelEvent;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.tree.Tree.Joint;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel.TreeNode;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;

@SuppressWarnings("unchecked")
public class TreePanelView extends BaseView<ModelData> {

  protected TreeStore treeStore;
  protected TreePanel tree;

  private TreeNode over;

  @Override
  public void bind(Component component, Store store) {
    super.bind(component, store);
    this.tree = (TreePanel) component;
    this.treeStore = (TreeStore) store;
  }

  public void collapse(TreeNode node) {
    node.container.getStyle().setProperty("display", "none");
    tree.refresh(node.m);
  }
  
  public Element getContainer(TreeNode node) {
    if (node.container == null) {
      node.container = node.element.getFirstChildElement().getNextSiblingElement().cast();
    }
    return node.container;
  }

  public void expand(TreeNode node) {
    node.container.getStyle().setProperty("display", "block");
    tree.refresh(node.m);
  }

  public Element getCheckElement(TreeNode node) {
    if (node.check == null) {
      node.check = El.fly(node.element).selectNode(".x-ftree2-check div").dom;
    }
    return node.check;
  }

  public Element getJointElement(TreeNode node) {
    if (node.joint == null) {
      node.joint = El.fly(node.element).selectNode(".x-ftree2-joint").dom;
    }
    return node.joint;
  }

  public native String getTemplate(ModelData m, String id, String text, String iconStyle,
      boolean checked, int joint, int level) /*-{
    var j = "";
    switch (joint) {
      case(1):
       j = "x-ftree2-joint-plus";
       break;
       case(2):
       j = "x-ftree2-joint-minus";
       break;

    }
    var s = '<div style="width: 18px"></div>';
    if (iconStyle && iconStyle.indexOf('.') != -1) {
      s = '<img src=' + iconStyle + '></img>';
      iconStyle = '';
    }

    return ['<div id=' + id + ' class="x-tree-item x-ftree2-arrows">',
              '<div class="x-ftree2-node x-ftree2-collapsed">',
              '<table cellspacing="0" cellpadding="0" style="table-layout: fixed"><tr>',
              '<td style="width: ' + (level * 18) + '"><div style="width: ' + (level * 18) + '"></div></td>',
              '<td class="x-ftree2-joint ' + j + '"><div></div></td>',
              '' + (!checked ? '' : '<td class="x-ftree2-check"><div class="my-tree-notchecked"></div></td>'),
              '<td class="x-ftree2-icon ' + iconStyle + '">' + s + '</td>',
              '<td class="x-ftree2-text"><span>' + text + '</span></td>',
              '</tr></table>',
              '</div>',
              '<div class="x-ftree2-el-ct"/></div>',
            '</div>'].join("");
  }-*/;

  public Element getTextElement(TreeNode node) {
    if (node.joint == null) {
      node.text = El.fly(node.element).selectNode(".x-ftree2-text span").dom;
    }
    return node.text;

  }

  public boolean isSelectableTarget(ModelData m, Element target) {
    TreeNode n = tree.findNode(m);
    boolean result = getJointElement(n) != target;
    if (result && tree.isCheckable()) {
      return getCheckElement(n) != target;
    }
    return result;
  }

  public void onCheckChange(TreeNode node, boolean check) {
    node.check.setClassName(check ? "my-tree-checked" : "my-tree-notchecked");
  }

  public void onEvent(TreePanelEvent ce) {
    int type = ce.getEventTypeInt();
    switch (type) {
      case Event.ONMOUSEOVER:
        onMouseOver(ce);
        break;
      case Event.ONMOUSEOUT:
        onMouseOut(ce);
        break;
    }
  }

  public void onIconStyleChange(TreeNode node, String iconStyle) {
    El iconEl = El.fly(node.element).selectNode(".x-ftree2-icon");
    if (iconStyle != null) {
      iconEl.setStyleAttribute("display", "");
      iconEl.setStyleName("x-ftree2-icon " + iconStyle);
    } else {
      iconEl.setStyleAttribute("display", "none");
    }
  }

  public void onJointChange(TreeNode node, Joint joint) {
    Element jointEl = getJointElement(node);
    switch (joint) {
      case NONE:
        jointEl.setClassName("x-ftree2-joint");
        break;
      case EXPANDED:
        jointEl.setClassName("x-ftree2-joint x-ftree2-joint-minus");
        break;
      case COLLAPSED:
        jointEl.setClassName("x-ftree2-joint x-ftree2-joint-plus");
        break;
    }
  }

  public void onOverChange(TreeNode node, boolean select) {
    El.fly(node.element.getFirstChildElement()).setStyleName("x-ftree2-node-over", select);
  }

  public void onSelectChange(ModelData model, boolean select) {
    TreeNode node = tree.findNode(model);
    if (node != null) {
      El.fly(node.element.getFirstChildElement()).setStyleName("x-ftree2-selected",
          select);
    }
  }

  public void onTextChange(TreeNode node, String text) {
    Element textEl = getTextElement(node);
    if (textEl != null) {
      textEl.setInnerHTML(text);
    }
  }

  private void onMouseOut(TreePanelEvent ce) {
    if (over != null) {
      onOverChange(over, false);
    }
  }

  private void onMouseOver(TreePanelEvent ce) {
    if (ce.getItem() != null) {
      onOverChange(ce.getNode(), true);
      over = ce.getNode();
    }
  }

}
