/*
 * Ext GWT 2.1.3 - Ext for GWT
 * Copyright(c) 2007-2010, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.event;

import com.google.gwt.event.dom.client.KeyCodes;

/**
 * EventTypes which map to GWT <code>KeyboardListener</code> key codes.
 */
public class KeyboardEvents {
  /**
   * Keyboard alt key event type.
   */
  public static final EventType Alt = new EventType(KeyCodes.KEY_ALT);
  
  /**
   * Keyboard backspace key event type.
   */
  public static final EventType BackSpace = new EventType(KeyCodes.KEY_BACKSPACE);
  
  /**
   * Keyboard control key event type.
   */
  public static final EventType Control = new EventType(KeyCodes.KEY_CTRL);
  
  /**
   * Keyboard delete key event type.
   */
  public static final EventType Delete = new EventType(KeyCodes.KEY_DELETE);
  
  /**
   * Keyboard down key event type.
   */
  public static final EventType Down = new EventType(KeyCodes.KEY_DOWN);
  
  /**
   * Keyboard end key event type.
   */
  public static final EventType End = new EventType(KeyCodes.KEY_END);
  
  /**
   * Keyboard enter key event type.
   */
  public static final EventType Enter = new EventType(KeyCodes.KEY_ENTER);
  
  /**
   * Keyboard escape key event type.
   */
  public static final EventType Escape = new EventType(KeyCodes.KEY_ESCAPE);
  
  /**
   * Keyboard home key event type.
   */
  public static final EventType Home = new EventType(KeyCodes.KEY_HOME);
  
  /**
   * Keyboard left key event type.
   */
  public static final EventType Left = new EventType(KeyCodes.KEY_LEFT);
  
  /**
   * Keyboard page down key event type.
   */
  public static final EventType PageDown = new EventType(KeyCodes.KEY_PAGEDOWN);
  
  /**
   * Keyboard page up key event type.
   */
  public static final EventType PageUp = new EventType(KeyCodes.KEY_PAGEUP);
  
  /**
   * Keyboard right key event type.
   */
  public static final EventType Right = new EventType(KeyCodes.KEY_RIGHT);
  
  /**
   * Keyboard shift key event type.
   */
  public static final EventType Shift = new EventType(KeyCodes.KEY_SHIFT);
  
  /**
   * Keyboard tab down key event type.
   */
  public static final EventType Tab = new EventType(KeyCodes.KEY_TAB);
  
  /**
   * Keyboard up key event type.
   */
  public static final EventType Up = new EventType(KeyCodes.KEY_UP);
  
  
}
