/*
 * Ext GWT 2.1.3 - Ext for GWT
 * Copyright(c) 2007-2010, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */
package com.extjs.gxt.ui.client.widget;

/**
 * ARIA component support.
 */
public class AriaSupport {

  String labelledBy;
  String role;
  boolean ignore;
  String describedBy;
  boolean presentation;
  Component c;

  AriaSupport(Component c) {
    this.c = c; 
  }
  
  /**
   * Returns the ARIA described by id.
   * 
   * @return the ARIA described by id
   */
  public String getDescribedBy() {
    return describedBy;
  }

  /**
   * Returns the ARIA labelled by id.
   * 
   * @return the ARIA labelled by id.
   */
  public String getLabelledBy() {
    return labelledBy;
  }

  /**
   * Returns the ARIA role.
   * 
   * @return the ARIA role
   */
  public String getRole() {
    return role;
  }

  /**
   * Returns true if the component will be ignored by the ARIA and FocusManager
   * API.
   * 
   * @return true if component is being ignored
   */
  public boolean isIgnore() {
    return ignore;
  }

  /**
   * Returns true if the component is a presentation element.
   * 
   * @return true for presentation
   */
  public boolean isPresentation() {
    return presentation;
  }

  /**
   * Sets the ARIA described by attribute on the component.
   * 
   * @param describedBy the id of the element with the label
   */
  public void setDescribedBy(String describedBy) {
    this.describedBy = describedBy;
    if (c.isRendered()) {
      c.setAriaState("aria-describedby", describedBy);
    }
  }

  /**
   * True to mark this component to be ignored by the ARIA and FocusManager API
   * (defaults to false). Typically set to true for any containers that should
   * not be navigable to.
   * 
   * @param ignore true to ignore
   */
  public void setIgnore(boolean ignore) {
    this.ignore = ignore;
  }

  /**
   * Sets the ARIA described by attribute on the component.
   * 
   * @param labelledBy the id of the element with the label
   */
  public void setLabelledBy(String labelledBy) {
    this.labelledBy = labelledBy;
    if (c.isRendered()) {
      c.setAriaState("aria-labelledby", labelledBy);
    }
  }

  /**
   * True to mark this component as a ARIA presentation element.
   * 
   * @param presentation true for presentation
   */
  public void setPresentation(boolean presentation) {
    this.presentation = presentation;
    setIgnore(true);
  }

  /**
   * Sets the ARIA role.
   * 
   * @param role the ARIA role
   */
  public void setRole(String role) {
    this.role = role;
    if (c.isRendered()) {
      c.setAriaRole(role);
    }
  }

}
