/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.CollectionsExt;
import com.extollit.collect.FilterIterable;
import java.util.ArrayList;
import java.util.List;

public class CombinationsIterator<T>
extends FilterIterable.Iter<List<T>> {
    private final List<T> delegate;
    private final List<T> workspace;
    private final int[] indexStack;
    private final int spanSize;
    private int stackPointer;

    public CombinationsIterator(Iterable<T> delegate, int rank) {
        this.delegate = CollectionsExt.toList(delegate);
        this.indexStack = new int[rank];
        this.workspace = new ArrayList<T>(rank);
        this.stackPointer = 0;
        this.indexStack[0] = -1;
        this.spanSize = this.delegate.size() - this.indexStack.length;
        for (int c = 0; c < this.indexStack.length; ++c) {
            this.workspace.add(c, null);
        }
    }

    @Override
    protected List<T> findNext() {
        while (this.stackPointer >= 0) {
            int n = this.stackPointer;
            this.indexStack[n] = this.indexStack[n] + 1;
            if (this.indexStack[n] <= this.spanSize + this.stackPointer) break;
            --this.stackPointer;
        }
        if (this.stackPointer >= 0) {
            this.workspace.set(this.stackPointer, this.delegate.get(this.indexStack[this.stackPointer]));
            for (int c = this.stackPointer + 1; c < this.indexStack.length; ++c) {
                this.indexStack[c] = this.indexStack[c - 1] + 1;
                ++this.stackPointer;
                this.workspace.set(c, this.delegate.get(this.indexStack[c]));
            }
            return new ArrayList<T>(this.workspace);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Combinations iterator does not support removal of combinations because it's functional mapping to the underlying collection is non-injective");
    }
}

