/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.immutable;

import com.extollit.linalg.mutable.Vec3i;
import java.text.MessageFormat;

public final class VertexOffset {
    public final byte dx;
    public final byte dy;
    public final byte dz;

    public VertexOffset() {
        this(1, 0, 0);
    }

    public VertexOffset(int dx, int dy, int dz) {
        assert (dx >= -1 && dx <= 1);
        assert (dy >= -1 && dy <= 1);
        assert (dz >= -1 && dz <= 1);
        this.dx = (byte)dx;
        this.dy = (byte)dy;
        this.dz = (byte)dz;
    }

    public VertexOffset mask() {
        return new VertexOffset(~(~((this.dx & 1) - 1)), ~(~((this.dy & 1) - 1)), ~(~((this.dz & 1) - 1)));
    }

    public VertexOffset pcross(VertexOffset other) {
        int dx = this.dy * other.dz - this.dz * other.dy;
        int dy = this.dz * other.dx - this.dx * other.dz;
        int dz = this.dx * other.dy - this.dy * other.dx;
        return new VertexOffset(dx, dy, dz);
    }

    public VertexOffset orthog() {
        return new VertexOffset(this.dy ^ this.dz, this.dx ^ this.dz, this.dy ^ this.dx);
    }

    public Vec3i offset(Vec3i vec) {
        vec.x += this.dx;
        vec.y += this.dy;
        vec.z += this.dz;
        return vec;
    }

    public VertexOffset sq() {
        return new VertexOffset(this.dx * this.dx, this.dy * this.dy, this.dz * this.dz);
    }

    public VertexOffset mul(VertexOffset offset) {
        return new VertexOffset(this.dx * offset.dx, this.dy * offset.dy, this.dz * offset.dz);
    }

    public VertexOffset sub(VertexOffset offset) {
        return new VertexOffset(this.dx - offset.dx, this.dy - offset.dy, this.dz - offset.dz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertexOffset that = (VertexOffset)o;
        return (this.dx ^ that.dx | this.dy ^ that.dy | this.dz ^ that.dz) == 0;
    }

    public int hashCode() {
        int result = this.dx;
        result = 31 * result + this.dy;
        result = 31 * result + this.dz;
        return result;
    }

    public String toString() {
        return MessageFormat.format("< {0}, {1}, {2} >", this.dx, this.dy, this.dz);
    }
}

