/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.num;

import com.extollit.num.ILinearFunction;

public class CachedLinearFunction<F extends ILinearFunction>
implements ILinearFunction {
    public final F host;
    public final float min;
    public final float max;
    public final float step;
    private final float[] cacheFunc;

    public CachedLinearFunction(F host, float min, float max, float step) {
        this.host = host;
        this.min = min;
        this.max = max;
        this.step = step;
        int c = 0;
        int length = (int)Math.ceil((max - min) / step) + 1;
        float[] cacheFunc = new float[length];
        for (double i = (double)min; i <= (double)max; i += (double)step) {
            cacheFunc[c] = (float)host.f(i);
            ++c;
        }
        this.cacheFunc = cacheFunc;
    }

    @Override
    public final double f(double x) {
        return this.cacheFunc[(int)Math.floor((this.clamp(x) - (double)this.min) / (double)this.step)];
    }

    protected double clamp(double x) {
        if (x < (double)this.min) {
            x = this.min;
        }
        if (x > (double)this.max) {
            x = this.max;
        }
        return x;
    }
}

