/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.test.property;

import com.extollit.num.IntRange;
import com.extollit.test.property.AbstractCollectionGenerator;
import com.extollit.test.property.EnumGen;
import com.extollit.test.property.IGenerator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionGenerators {

    public static final class ListGen<T>
    extends AbstractCollectionGenerator<T, List<T>>
    implements IGenerator<List<T>> {
        public ListGen(IGenerator<T> elementGenerator, IntRange quantityRange) {
            super(elementGenerator, quantityRange);
        }

        @Override
        protected List<T> createCollection(int capacity) {
            return new ArrayList(capacity);
        }
    }

    public static final class EnumSetGen<E extends Enum<E>>
    extends AbstractCollectionGenerator<E, EnumSet<E>>
    implements IGenerator<EnumSet<E>> {
        public final Class<E> clazz;

        public EnumSetGen(Class<E> clazz, IntRange quantityRange) {
            super(new EnumGen<E>(clazz), quantityRange);
            this.clazz = clazz;
        }

        public EnumSetGen(Class<E> clazz) {
            this(clazz, new IntRange(0, ((Enum[])clazz.getEnumConstants()).length));
        }

        @Override
        protected EnumSet<E> createCollection(int capacity) {
            return EnumSet.noneOf(this.clazz);
        }
    }

    public static final class SetGen<T>
    extends AbstractCollectionGenerator<T, Set<T>>
    implements IGenerator<Set<T>> {
        public SetGen(IGenerator<T> elementGenerator, IntRange quantityRange) {
            super(elementGenerator, quantityRange);
        }

        @Override
        protected Set<T> createCollection(int capacity) {
            return new HashSet(capacity);
        }
    }
}

