/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractNode;
import com.extollit.tree.binary.AbstractTreeNodeIterator;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LevelOrderTreeNodeIterator<T, Node extends AbstractNode<T, Node>>
extends AbstractTreeNodeIterator<T, Node> {
    private List<Node> breadth;
    private Iterator<Node> biter;
    private Node current;
    private AbstractTreeNodeIterator.Arm arm;

    public LevelOrderTreeNodeIterator(IBinaryTree<T, Node> tree) {
        super(tree);
    }

    private Node add(Node node) {
        this.breadth.add(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node findNext() {
        if (this.first()) {
            AbstractNode root = (AbstractNode)this.tree.root();
            this.breadth = new LinkedList<Node>();
            this.arm = AbstractTreeNodeIterator.Arm.top;
            this.current = root;
            return this.current;
        }
        while (true) {
            Object current;
            if ((current = this.current) == null || this.arm == AbstractTreeNodeIterator.Arm.right) {
                if (this.biter == null || !this.biter.hasNext()) {
                    this.nextTier();
                }
                if (!this.biter.hasNext()) {
                    return null;
                }
                current = this.current = (AbstractNode)this.biter.next();
                this.arm = AbstractTreeNodeIterator.Arm.top;
            }
            ITreeNode left = ((AbstractNode)current).left();
            ITreeNode right = ((AbstractNode)current).right();
            if (this.arm == AbstractTreeNodeIterator.Arm.top) {
                try {
                    if (left != null) {
                        ITreeNode iTreeNode = this.add(left);
                        return (Node)iTreeNode;
                    }
                }
                finally {
                    this.arm = AbstractTreeNodeIterator.Arm.left;
                }
            }
            if (this.arm != AbstractTreeNodeIterator.Arm.left) continue;
            try {
                if (right == null) continue;
                ITreeNode iTreeNode = this.add(right);
                return (Node)iTreeNode;
            }
            finally {
                this.arm = AbstractTreeNodeIterator.Arm.right;
                continue;
            }
            break;
        }
    }

    private void nextTier() {
        this.biter = this.breadth.iterator();
        this.breadth = new LinkedList<Node>();
        this.arm = AbstractTreeNodeIterator.Arm.top;
    }

    @Override
    protected boolean first() {
        return this.breadth == null;
    }
}

