/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri;

import com.eygraber.uri.UriCodec;
import com.eygraber.uri.parts.Part;
import com.eygraber.uri.parts.PathPart;
import com.eygraber.uri.uris.HierarchicalUri;
import com.eygraber.uri.uris.OpaqueUri;
import com.eygraber.uri.uris.StringUri;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0005\bf\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002<=J\b\u00100\u001a\u000201H&J\u0011\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u0000H\u0096\u0002J\u0018\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0017H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u000309H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030!2\u0006\u00105\u001a\u00020\u0003H\u0016J\b\u0010;\u001a\u00020\u0000H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0014\u0010\n\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0012\u0010\u001b\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0005R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0005R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0005R\u0014\u0010*\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0005R\u0014\u0010,\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0005R\u0014\u0010.\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0005\u00a8\u0006>"}, d2={"Lcom/eygraber/uri/Uri;", "", "authority", "", "getAuthority", "()Ljava/lang/String;", "encodedAuthority", "getEncodedAuthority", "encodedFragment", "getEncodedFragment", "encodedPath", "getEncodedPath", "encodedQuery", "getEncodedQuery", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "encodedUserInfo", "getEncodedUserInfo", "fragment", "getFragment", "host", "getHost", "isAbsolute", "", "()Z", "isHierarchical", "isOpaque", "isRelative", "lastPathSegment", "getLastPathSegment", "path", "getPath", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "port", "", "getPort", "()I", "query", "getQuery", "scheme", "getScheme", "schemeSpecificPart", "getSchemeSpecificPart", "userInfo", "getUserInfo", "buildUpon", "Lcom/eygraber/uri/Builder;", "compareTo", "other", "getBooleanQueryParameter", "key", "defaultValue", "getQueryParameter", "getQueryParameterNames", "", "getQueryParameters", "normalizeScheme", "Builder", "Companion", "uri"})
public interface Uri
extends Comparable<Uri> {
    @NotNull
    public static final Companion Companion = com.eygraber.uri.Uri$Companion.$$INSTANCE;

    public boolean isHierarchical();

    public boolean isOpaque();

    public boolean isRelative();

    public boolean isAbsolute();

    @Nullable
    public String getScheme();

    @Nullable
    public String getSchemeSpecificPart();

    @Nullable
    public String getEncodedSchemeSpecificPart();

    @Nullable
    public String getAuthority();

    @Nullable
    public String getEncodedAuthority();

    @Nullable
    public String getUserInfo();

    @Nullable
    public String getEncodedUserInfo();

    @Nullable
    public String getHost();

    public int getPort();

    @Nullable
    public String getPath();

    @Nullable
    public String getEncodedPath();

    @Nullable
    public String getQuery();

    @Nullable
    public String getEncodedQuery();

    @Nullable
    public String getFragment();

    @Nullable
    public String getEncodedFragment();

    @NotNull
    public List<String> getPathSegments();

    @Nullable
    public String getLastPathSegment();

    @NotNull
    public Set<String> getQueryParameterNames();

    @NotNull
    public List<String> getQueryParameters(@NotNull String var1);

    @Nullable
    public String getQueryParameter(@NotNull String var1);

    public boolean getBooleanQueryParameter(@NotNull String var1, boolean var2);

    @NotNull
    public Uri normalizeScheme();

    @Override
    public int compareTo(@NotNull Uri var1);

    @NotNull
    public com.eygraber.uri.Builder buildUpon();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J\u0017\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0012\u0010\u0016\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0017\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0018\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0019\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u001a\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0016J\u0017\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001bJ\u0012\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\r\u0010\u001e\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b!J\u0017\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\"J\u0012\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0016J\u0017\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b#J\u0012\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u000bH\u0016J\u0017\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b$J\u0012\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/eygraber/uri/Uri$Builder;", "Lcom/eygraber/uri/Builder;", "()V", "authority", "Lcom/eygraber/uri/parts/Part;", "fragment", "opaquePart", "path", "Lcom/eygraber/uri/parts/PathPart;", "query", "scheme", "", "appendEncodedPath", "newSegment", "appendPath", "appendQueryParameter", "key", "value", "authority$uri", "build", "Lcom/eygraber/uri/Uri;", "clearQuery", "encodedAuthority", "encodedFragment", "encodedOpaquePart", "encodedPath", "encodedQuery", "fragment$uri", "hasSchemeOrAuthority", "", "isAuthoritySet", "isAuthoritySet$uri", "isSchemeSet", "isSchemeSet$uri", "opaquePart$uri", "path$uri", "query$uri", "toString", "uri"})
    public static final class Builder
    implements com.eygraber.uri.Builder {
        @Nullable
        private String scheme;
        @Nullable
        private Part opaquePart;
        @Nullable
        private Part authority;
        @Nullable
        private PathPart path;
        @Nullable
        private Part query;
        @Nullable
        private Part fragment;

        public final boolean isSchemeSet$uri() {
            return this.scheme != null;
        }

        public final boolean isAuthoritySet$uri() {
            return this.authority != null;
        }

        @Override
        @NotNull
        public Builder scheme(@Nullable String scheme2) {
            Builder builder;
            Builder $this$scheme_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$scheme_u24lambda_u240.scheme = scheme2;
            return builder;
        }

        @NotNull
        public final Builder opaquePart$uri(@Nullable Part opaquePart) {
            Builder builder;
            Builder $this$opaquePart_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$opaquePart_u24lambda_u241.opaquePart = opaquePart;
            return builder;
        }

        @Override
        @NotNull
        public Builder opaquePart(@Nullable String opaquePart) {
            return this.opaquePart$uri(Part.Companion.fromDecoded(opaquePart));
        }

        @Override
        @NotNull
        public Builder encodedOpaquePart(@Nullable String opaquePart) {
            return this.opaquePart$uri(Part.Companion.fromEncoded(opaquePart));
        }

        @NotNull
        public final Builder authority$uri(@Nullable Part authority2) {
            Builder builder;
            Builder $this$authority_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$authority_u24lambda_u242.opaquePart = null;
            $this$authority_u24lambda_u242.authority = authority2;
            return builder;
        }

        @Override
        @NotNull
        public Builder authority(@Nullable String authority2) {
            return this.authority$uri(Part.Companion.fromDecoded(authority2));
        }

        @Override
        @NotNull
        public Builder encodedAuthority(@Nullable String authority2) {
            return this.authority$uri(Part.Companion.fromEncoded(authority2));
        }

        @NotNull
        public final Builder path$uri(@Nullable PathPart path2) {
            Builder builder;
            Builder $this$path_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$path_u24lambda_u243.opaquePart = null;
            $this$path_u24lambda_u243.path = path2;
            return builder;
        }

        @Override
        @NotNull
        public Builder path(@Nullable String path2) {
            return this.path$uri(PathPart.Companion.fromDecoded(path2));
        }

        @Override
        @NotNull
        public Builder encodedPath(@Nullable String path2) {
            return this.path$uri(PathPart.Companion.fromEncoded(path2));
        }

        @Override
        @NotNull
        public Builder appendPath(@NotNull String newSegment) {
            Intrinsics.checkNotNullParameter((Object)newSegment, (String)"newSegment");
            return this.path$uri(PathPart.Companion.appendDecodedSegment(this.path, newSegment));
        }

        @Override
        @NotNull
        public Builder appendEncodedPath(@NotNull String newSegment) {
            Intrinsics.checkNotNullParameter((Object)newSegment, (String)"newSegment");
            return this.path$uri(PathPart.Companion.appendEncodedSegment(this.path, newSegment));
        }

        @NotNull
        public final Builder query$uri(@Nullable Part query2) {
            Builder builder;
            Builder $this$query_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$query_u24lambda_u244.opaquePart = null;
            $this$query_u24lambda_u244.query = query2;
            return builder;
        }

        @Override
        @NotNull
        public Builder query(@Nullable String query2) {
            return this.query$uri(Part.Companion.fromDecoded(query2));
        }

        @Override
        @NotNull
        public Builder encodedQuery(@Nullable String query2) {
            return this.query$uri(Part.Companion.fromEncoded(query2));
        }

        @NotNull
        public final Builder fragment$uri(@Nullable Part fragment2) {
            Builder builder;
            Builder $this$fragment_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$fragment_u24lambda_u245.fragment = fragment2;
            return builder;
        }

        @Override
        @NotNull
        public Builder fragment(@Nullable String fragment2) {
            return this.fragment$uri(Part.Companion.fromDecoded(fragment2));
        }

        @Override
        @NotNull
        public Builder encodedFragment(@Nullable String fragment2) {
            return this.fragment$uri(Part.Companion.fromEncoded(fragment2));
        }

        @Override
        @NotNull
        public Builder appendQueryParameter(@NotNull String key, @Nullable String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$appendQueryParameter_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$appendQueryParameter_u24lambda_u246.opaquePart = null;
            String encodedKey = UriCodec.INSTANCE.encode(key, null);
            String encodedValue = UriCodec.INSTANCE.encodeOrNull(value, null);
            String encodedParameter = encodedKey + "=" + encodedValue;
            if ($this$appendQueryParameter_u24lambda_u246.query == null) {
                $this$appendQueryParameter_u24lambda_u246.query = Part.Companion.fromEncoded(encodedParameter);
                return $this$appendQueryParameter_u24lambda_u246;
            }
            Part part = $this$appendQueryParameter_u24lambda_u246.query;
            Intrinsics.checkNotNull((Object)part);
            String oldQuery = part.getEncoded();
            $this$appendQueryParameter_u24lambda_u246.query = oldQuery == null || ((CharSequence)oldQuery).length() == 0 ? Part.Companion.fromEncoded(encodedParameter) : Part.Companion.fromEncoded(oldQuery + "&" + encodedParameter);
            return builder;
        }

        @Override
        @NotNull
        public Builder clearQuery() {
            return this.query$uri(null);
        }

        @Override
        @NotNull
        public Uri build() {
            Uri uri;
            Part opaquePart = this.opaquePart;
            if (opaquePart == null) {
                PathPart path2 = this.path;
                if (path2 == null || Intrinsics.areEqual((Object)path2, (Object)PathPart.Companion.getNULL())) {
                    path2 = PathPart.Companion.getEMPTY();
                } else if (this.hasSchemeOrAuthority()) {
                    path2 = PathPart.Companion.makeAbsolute(path2);
                }
                uri = new HierarchicalUri(this.scheme, this.authority, path2, this.query, this.fragment);
            } else {
                if (this.scheme == null) {
                    throw new UnsupportedOperationException("An opaque URI must have a scheme.");
                }
                uri = new OpaqueUri(this.scheme, opaquePart, this.fragment);
            }
            return uri;
        }

        private final boolean hasSchemeOrAuthority() {
            return this.scheme != null || this.authority != null && this.authority != Part.Companion.getNULL();
        }

        @NotNull
        public String toString() {
            return this.build().toString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/eygraber/uri/Uri$Companion;", "", "()V", "EMPTY", "Lcom/eygraber/uri/Uri;", "getEMPTY", "()Lcom/eygraber/uri/Uri;", "NOT_HIERARCHICAL", "", "fromParts", "scheme", "ssp", "fragment", "parse", "uriString", "parseOrNull", "uri"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\ncom/eygraber/uri/Uri$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,655:1\n1#2:656\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
        @NotNull
        private static final Uri EMPTY;

        private Companion() {
        }

        @NotNull
        public final Uri getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Uri parse(@NotNull String uriString2) {
            Intrinsics.checkNotNullParameter((Object)uriString2, (String)"uriString");
            return new StringUri(uriString2);
        }

        @Nullable
        public final Uri parseOrNull(@NotNull String uriString2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)uriString2, (String)"uriString");
            Object object2 = this;
            try {
                Companion $this$parseOrNull_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)new StringUri(uriString2));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            return (Uri)(Result.isFailure-impl((Object)object2) ? null : object2);
        }

        @NotNull
        public final Uri fromParts(@Nullable String scheme2, @Nullable String ssp2, @Nullable String fragment2) {
            if (scheme2 == null) {
                boolean $i$a$-requireNotNull-Uri$Companion$fromParts$32 = false;
                String $i$a$-requireNotNull-Uri$Companion$fromParts$32 = "scheme";
                throw new IllegalArgumentException($i$a$-requireNotNull-Uri$Companion$fromParts$32.toString());
            }
            if (ssp2 == null) {
                boolean bl = false;
                String string = "ssp";
                throw new IllegalArgumentException(string.toString());
            }
            return new OpaqueUri(scheme2, Part.Companion.fromDecoded(ssp2), Part.Companion.fromDecoded(fragment2));
        }

        static {
            $$INSTANCE = new Companion();
            EMPTY = new HierarchicalUri(null, Part.Companion.getNULL(), PathPart.Companion.getEMPTY(), Part.Companion.getNULL(), Part.Companion.getNULL());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isOpaque(@NotNull Uri $this) {
            return !$this.isHierarchical();
        }

        public static boolean isAbsolute(@NotNull Uri $this) {
            return !$this.isRelative();
        }

        @NotNull
        public static Set<String> getQueryParameterNames(@NotNull Uri $this) {
            int end;
            if ($this.isOpaque()) {
                throw new UnsupportedOperationException("This isn't a hierarchical URI.");
            }
            String string = $this.getEncodedQuery();
            if (string == null) {
                return SetsKt.emptySet();
            }
            String query2 = string;
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            int start = 0;
            do {
                String name;
                int next;
                end = (next = StringsKt.indexOf$default((CharSequence)query2, (char)'&', (int)start, (boolean)false, (int)4, null)) == -1 ? query2.length() : next;
                int separator = StringsKt.indexOf$default((CharSequence)query2, (char)'=', (int)start, (boolean)false, (int)4, null);
                if (separator > end || separator == -1) {
                    separator = end;
                }
                Intrinsics.checkNotNullExpressionValue((Object)query2.substring(start, separator), (String)"substring(...)");
                names.add(UriCodec.decode$default(UriCodec.INSTANCE, name, false, false, 6, null));
            } while ((start = end + 1) < query2.length());
            return names;
        }

        @NotNull
        public static List<String> getQueryParameters(@NotNull Uri $this, @NotNull String key) {
            String string;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if ($this.isOpaque()) {
                throw new UnsupportedOperationException("This isn't a hierarchical URI.");
            }
            String string2 = $this.getEncodedQuery();
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            String query2 = string2;
            try {
                string = UriCodec.INSTANCE.encode(key);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            String encodedKey = string;
            ArrayList<String> values = new ArrayList<String>();
            int start = 0;
            while (true) {
                int nextAmpersand;
                int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query2, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : query2.length();
                int separator = StringsKt.indexOf$default((CharSequence)query2, (char)'=', (int)start, (boolean)false, (int)4, null);
                if (separator > end || separator == -1) {
                    separator = end;
                }
                if (separator - start == encodedKey.length() && StringsKt.regionMatches$default((String)query2, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                    if (separator == end) {
                        values.add("");
                    } else {
                        String string3 = query2.substring(separator + 1, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        values.add(UriCodec.decode$default(UriCodec.INSTANCE, string3, false, false, 6, null));
                    }
                }
                if (nextAmpersand == -1) break;
                start = nextAmpersand + 1;
            }
            return values;
        }

        @Nullable
        public static String getQueryParameter(@NotNull Uri $this, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = $this.getEncodedQuery();
            if (string == null) {
                return null;
            }
            String query2 = string;
            if ($this.isOpaque()) {
                throw new UnsupportedOperationException("This isn't a hierarchical URI.");
            }
            String encodedKey = UriCodec.INSTANCE.encode(key, null);
            int length = query2.length();
            int start = 0;
            while (true) {
                int nextAmpersand;
                int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query2, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : length;
                int separator = StringsKt.indexOf$default((CharSequence)query2, (char)'=', (int)start, (boolean)false, (int)4, null);
                if (separator > end || separator == -1) {
                    separator = end;
                }
                if (separator - start == encodedKey.length() && StringsKt.regionMatches$default((String)query2, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                    String string2;
                    if (separator == end) {
                        string2 = "";
                    } else {
                        String string3 = query2.substring(separator + 1, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        String encodedValue = string3;
                        string2 = UriCodec.INSTANCE.decode(encodedValue, true, false);
                    }
                    return string2;
                }
                if (nextAmpersand == -1) break;
                start = nextAmpersand + 1;
            }
            return null;
        }

        public static boolean getBooleanQueryParameter(@NotNull Uri $this, @NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = $this.getQueryParameter(key);
            if (string == null) {
                return defaultValue;
            }
            String flag = string;
            String string2 = flag.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            flag = string2;
            return !Intrinsics.areEqual((Object)"false", (Object)flag) && !Intrinsics.areEqual((Object)"0", (Object)flag);
        }

        @NotNull
        public static Uri normalizeScheme(@NotNull Uri $this) {
            String string = $this.getScheme();
            if (string == null) {
                return $this;
            }
            String scheme2 = string;
            String string2 = scheme2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String lowerScheme = string2;
            return Intrinsics.areEqual((Object)scheme2, (Object)lowerScheme) ? $this : $this.buildUpon().scheme(lowerScheme).build();
        }

        public static int compareTo(@NotNull Uri $this, @NotNull Uri other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return $this.toString().compareTo(other.toString());
        }
    }
}

