/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.bigmath.functions.bigdecimalmath;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.bigmath.utils.BigDecimalMathExtension;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

public abstract class AbstractBigMathFunction
extends AbstractFunction {
    public EvaluationValue evaluate(Expression expression, Token token, EvaluationValue ... evaluationValues) throws EvaluationException {
        try {
            BigDecimal[] values = (BigDecimal[])Arrays.stream(evaluationValues).map(EvaluationValue::getNumberValue).toArray(BigDecimal[]::new);
            MathContext mathContext = expression.getConfiguration().getMathContext();
            return expression.convertValue((Object)BigDecimalMathExtension.round(this.evaluateBigMath(mathContext, values), mathContext));
        }
        catch (ArithmeticException e) {
            throw new EvaluationException(token, e.getMessage());
        }
    }

    protected abstract BigDecimal evaluateBigMath(MathContext var1, BigDecimal ... var2) throws EvaluationException;
}

