/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.bigmath.operators.bigdecimalmath;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.operators.AbstractOperator;
import com.ezylang.evalex.operators.InfixOperator;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;

@InfixOperator(precedence=40, leftAssociative=false)
public class BigMathInfixPowerOfOperator
extends AbstractOperator {
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            return expression.convertValue((Object)BigDecimalMath.pow((BigDecimal)leftOperand.getNumberValue(), (BigDecimal)rightOperand.getNumberValue(), (MathContext)expression.getConfiguration().getMathContext()));
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation((Token)operatorToken);
    }

    public int getPrecedence(ExpressionConfiguration configuration) {
        return configuration.getPowerOfPrecedence();
    }
}

