/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.parser;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.config.FunctionDictionaryIfc;
import com.ezylang.evalex.config.OperatorDictionaryIfc;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.operators.OperatorIfc;
import com.ezylang.evalex.parser.ParseException;
import com.ezylang.evalex.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    private final String expressionString;
    private final OperatorDictionaryIfc operatorDictionary;
    private final FunctionDictionaryIfc functionDictionary;
    private final ExpressionConfiguration configuration;
    private final List<Token> tokens = new ArrayList<Token>();
    private int currentColumnIndex = 0;
    private int currentChar = -2;
    private int braceBalance;
    private int arrayBalance;

    public Tokenizer(String expressionString, ExpressionConfiguration configuration) {
        this.expressionString = expressionString;
        this.configuration = configuration;
        this.operatorDictionary = configuration.getOperatorDictionary();
        this.functionDictionary = configuration.getFunctionDictionary();
    }

    public List<Token> parse() throws ParseException {
        Token currentToken = this.getNextToken();
        while (currentToken != null) {
            if (currentToken.getType() == Token.TokenType.BRACE_OPEN && this.implicitMultiplicationPossible()) {
                if (this.configuration.isImplicitMultiplicationAllowed()) {
                    Token multiplication = new Token(currentToken.getStartPosition(), "*", Token.TokenType.INFIX_OPERATOR);
                    this.tokens.add(multiplication);
                } else {
                    throw new ParseException(currentToken, "Missing operator");
                }
            }
            this.tokens.add(currentToken);
            currentToken = this.getNextToken();
        }
        if (this.braceBalance > 0) {
            throw new ParseException(this.expressionString, "Closing brace not found");
        }
        if (this.arrayBalance > 0) {
            throw new ParseException(this.expressionString, "Closing array not found");
        }
        return this.tokens;
    }

    private Token getNextToken() throws ParseException {
        this.skipBlanks();
        if (this.currentChar == -1) {
            return null;
        }
        if (this.currentChar == 34) {
            return this.parseStringLiteral();
        }
        if (this.currentChar == 40) {
            return this.parseBraceOpen();
        }
        if (this.currentChar == 41) {
            return this.parseBraceClose();
        }
        if (this.currentChar == 91 && this.configuration.isArraysAllowed()) {
            return this.parseArrayOpen();
        }
        if (this.currentChar == 93 && this.configuration.isArraysAllowed()) {
            return this.parseArrayClose();
        }
        if (this.currentChar == 46 && !this.isNumberChar(this.peekNextChar()) && this.configuration.isStructuresAllowed()) {
            return this.parseStructureSeparator();
        }
        if (this.currentChar == 44) {
            Token token = new Token(this.currentColumnIndex, ",", Token.TokenType.COMMA);
            this.consumeChar();
            return token;
        }
        if (this.isIdentifierStart(this.currentChar)) {
            return this.parseIdentifier();
        }
        if (this.isNumberStart(this.currentChar)) {
            return this.parseNumberLiteral();
        }
        return this.parseOperator();
    }

    private Token parseStructureSeparator() throws ParseException {
        Token token = new Token(this.currentColumnIndex, ".", Token.TokenType.STRUCTURE_SEPARATOR);
        if (this.arrayOpenOrStructureSeparatorNotAllowed()) {
            throw new ParseException(token, "Structure separator not allowed here");
        }
        this.consumeChar();
        return token;
    }

    private Token parseArrayClose() throws ParseException {
        Token token = new Token(this.currentColumnIndex, "]", Token.TokenType.ARRAY_CLOSE);
        if (!this.arrayCloseAllowed()) {
            throw new ParseException(token, "Array close not allowed here");
        }
        this.consumeChar();
        --this.arrayBalance;
        if (this.arrayBalance < 0) {
            throw new ParseException(token, "Unexpected closing array");
        }
        return token;
    }

    private Token parseArrayOpen() throws ParseException {
        Token token = new Token(this.currentColumnIndex, "[", Token.TokenType.ARRAY_OPEN);
        if (this.arrayOpenOrStructureSeparatorNotAllowed()) {
            throw new ParseException(token, "Array open not allowed here");
        }
        this.consumeChar();
        ++this.arrayBalance;
        return token;
    }

    private Token parseBraceClose() throws ParseException {
        Token token = new Token(this.currentColumnIndex, ")", Token.TokenType.BRACE_CLOSE);
        this.consumeChar();
        --this.braceBalance;
        if (this.braceBalance < 0) {
            throw new ParseException(token, "Unexpected closing brace");
        }
        return token;
    }

    private Token parseBraceOpen() {
        Token token = new Token(this.currentColumnIndex, "(", Token.TokenType.BRACE_OPEN);
        this.consumeChar();
        ++this.braceBalance;
        return token;
    }

    private Token getPreviousToken() {
        return this.tokens.isEmpty() ? null : this.tokens.get(this.tokens.size() - 1);
    }

    private Token parseOperator() throws ParseException {
        OperatorIfc operator;
        String tokenString;
        boolean possibleNextOperatorFound;
        int tokenStartIndex = this.currentColumnIndex;
        StringBuilder tokenValue = new StringBuilder();
        do {
            tokenValue.append((char)this.currentChar);
            tokenString = tokenValue.toString();
            String possibleNextOperator = tokenString + (char)this.peekNextChar();
            possibleNextOperatorFound = this.prefixOperatorAllowed() && this.operatorDictionary.hasPrefixOperator(possibleNextOperator) || this.postfixOperatorAllowed() && this.operatorDictionary.hasPostfixOperator(possibleNextOperator) || this.infixOperatorAllowed() && this.operatorDictionary.hasInfixOperator(possibleNextOperator);
            this.consumeChar();
        } while (possibleNextOperatorFound);
        tokenString = tokenValue.toString();
        if (this.prefixOperatorAllowed() && this.operatorDictionary.hasPrefixOperator(tokenString)) {
            operator = this.operatorDictionary.getPrefixOperator(tokenString);
            return new Token(tokenStartIndex, tokenString, Token.TokenType.PREFIX_OPERATOR, operator);
        }
        if (this.postfixOperatorAllowed() && this.operatorDictionary.hasPostfixOperator(tokenString)) {
            operator = this.operatorDictionary.getPostfixOperator(tokenString);
            return new Token(tokenStartIndex, tokenString, Token.TokenType.POSTFIX_OPERATOR, operator);
        }
        if (this.operatorDictionary.hasInfixOperator(tokenString)) {
            operator = this.operatorDictionary.getInfixOperator(tokenString);
            return new Token(tokenStartIndex, tokenString, Token.TokenType.INFIX_OPERATOR, operator);
        }
        throw new ParseException(tokenStartIndex, tokenStartIndex + tokenString.length() - 1, tokenString, "Undefined operator '" + tokenString + "'");
    }

    private boolean implicitMultiplicationPossible() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return false;
        }
        switch (previousToken.getType()) {
            case BRACE_CLOSE: 
            case NUMBER_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private boolean arrayOpenOrStructureSeparatorNotAllowed() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return true;
        }
        switch (previousToken.getType()) {
            case BRACE_CLOSE: 
            case VARIABLE_OR_CONSTANT: 
            case ARRAY_CLOSE: {
                return false;
            }
        }
        return true;
    }

    private boolean arrayCloseAllowed() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return false;
        }
        switch (previousToken.getType()) {
            case BRACE_OPEN: 
            case INFIX_OPERATOR: 
            case PREFIX_OPERATOR: 
            case FUNCTION: 
            case COMMA: 
            case ARRAY_OPEN: {
                return false;
            }
        }
        return true;
    }

    private boolean prefixOperatorAllowed() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return true;
        }
        switch (previousToken.getType()) {
            case BRACE_OPEN: 
            case INFIX_OPERATOR: 
            case PREFIX_OPERATOR: 
            case COMMA: {
                return true;
            }
        }
        return false;
    }

    private boolean postfixOperatorAllowed() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return false;
        }
        switch (previousToken.getType()) {
            case BRACE_CLOSE: 
            case NUMBER_LITERAL: 
            case VARIABLE_OR_CONSTANT: 
            case STRING_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private boolean infixOperatorAllowed() {
        Token previousToken = this.getPreviousToken();
        if (previousToken == null) {
            return false;
        }
        switch (previousToken.getType()) {
            case BRACE_CLOSE: 
            case NUMBER_LITERAL: 
            case VARIABLE_OR_CONSTANT: 
            case STRING_LITERAL: 
            case POSTFIX_OPERATOR: {
                return true;
            }
        }
        return false;
    }

    private Token parseNumberLiteral() throws ParseException {
        int tokenStartIndex = this.currentColumnIndex;
        StringBuilder tokenValue = new StringBuilder();
        int nextChar = this.peekNextChar();
        if (this.currentChar == 48 && (nextChar == 120 || nextChar == 88)) {
            tokenValue.append((char)this.currentChar);
            this.consumeChar();
            tokenValue.append((char)this.currentChar);
            this.consumeChar();
            while (this.currentChar != -1 && this.isHexChar(this.currentChar)) {
                tokenValue.append((char)this.currentChar);
                this.consumeChar();
            }
        } else {
            int lastChar = -1;
            while (this.currentChar != -1 && this.isNumberChar(this.currentChar)) {
                tokenValue.append((char)this.currentChar);
                lastChar = this.currentChar;
                this.consumeChar();
            }
            if (lastChar == 101 || lastChar == 69 || lastChar == 43 || lastChar == 45) {
                throw new ParseException(new Token(tokenStartIndex, tokenValue.toString(), Token.TokenType.NUMBER_LITERAL), "Illegal scientific format");
            }
        }
        return new Token(tokenStartIndex, tokenValue.toString(), Token.TokenType.NUMBER_LITERAL);
    }

    private Token parseIdentifier() throws ParseException {
        int tokenStartIndex = this.currentColumnIndex;
        StringBuilder tokenValue = new StringBuilder();
        while (this.currentChar != -1 && this.isIdentifierChar(this.currentChar)) {
            tokenValue.append((char)this.currentChar);
            this.consumeChar();
        }
        String tokenName = tokenValue.toString();
        if (this.prefixOperatorAllowed() && this.operatorDictionary.hasPrefixOperator(tokenName)) {
            return new Token(tokenStartIndex, tokenName, Token.TokenType.PREFIX_OPERATOR, this.operatorDictionary.getPrefixOperator(tokenName));
        }
        if (this.postfixOperatorAllowed() && this.operatorDictionary.hasPostfixOperator(tokenName)) {
            return new Token(tokenStartIndex, tokenName, Token.TokenType.POSTFIX_OPERATOR, this.operatorDictionary.getPostfixOperator(tokenName));
        }
        if (this.operatorDictionary.hasInfixOperator(tokenName)) {
            return new Token(tokenStartIndex, tokenName, Token.TokenType.INFIX_OPERATOR, this.operatorDictionary.getInfixOperator(tokenName));
        }
        this.skipBlanks();
        if (this.currentChar == 40) {
            if (!this.functionDictionary.hasFunction(tokenName)) {
                throw new ParseException(tokenStartIndex, this.currentColumnIndex, tokenName, "Undefined function '" + tokenName + "'");
            }
            FunctionIfc function = this.functionDictionary.getFunction(tokenName);
            return new Token(tokenStartIndex, tokenName, Token.TokenType.FUNCTION, function);
        }
        return new Token(tokenStartIndex, tokenName, Token.TokenType.VARIABLE_OR_CONSTANT);
    }

    Token parseStringLiteral() throws ParseException {
        int tokenStartIndex = this.currentColumnIndex;
        StringBuilder tokenValue = new StringBuilder();
        this.consumeChar();
        boolean inQuote = true;
        while (inQuote && this.currentChar != -1) {
            if (this.currentChar == 92) {
                this.consumeChar();
                tokenValue.append(this.escapeCharacter(this.currentChar));
            } else if (this.currentChar == 34) {
                inQuote = false;
            } else {
                tokenValue.append((char)this.currentChar);
            }
            this.consumeChar();
        }
        if (inQuote) {
            throw new ParseException(tokenStartIndex, this.currentColumnIndex, tokenValue.toString(), "Closing quote not found");
        }
        return new Token(tokenStartIndex, tokenValue.toString(), Token.TokenType.STRING_LITERAL);
    }

    private char escapeCharacter(int character) throws ParseException {
        switch (character) {
            case 39: {
                return '\'';
            }
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
        }
        throw new ParseException(this.currentColumnIndex, 1, "\\" + (char)character, "Unknown escape character");
    }

    private boolean isNumberStart(int ch) {
        if (Character.isDigit(ch)) {
            return true;
        }
        return ch == 46 && Character.isDigit(this.peekNextChar());
    }

    private boolean isNumberChar(int ch) {
        int previousChar = this.peekPreviousChar();
        if (previousChar == 101 || previousChar == 69) {
            return Character.isDigit(ch) || ch == 43 || ch == 45;
        }
        return Character.isDigit(ch) || ch == 46 || ch == 101 || ch == 69;
    }

    private boolean isHexChar(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private boolean isIdentifierStart(int ch) {
        return Character.isLetter(ch) || ch == 95;
    }

    private boolean isIdentifierChar(int ch) {
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == 95;
    }

    private void skipBlanks() {
        if (this.currentChar == -2) {
            this.consumeChar();
        }
        while (this.currentChar != -1 && Character.isWhitespace(this.currentChar)) {
            this.consumeChar();
        }
    }

    private int peekNextChar() {
        return this.currentColumnIndex == this.expressionString.length() ? -1 : (int)this.expressionString.charAt(this.currentColumnIndex);
    }

    private int peekPreviousChar() {
        return this.currentColumnIndex == 1 ? -1 : (int)this.expressionString.charAt(this.currentColumnIndex - 2);
    }

    private void consumeChar() {
        this.currentChar = this.currentColumnIndex == this.expressionString.length() ? -1 : (int)this.expressionString.charAt(this.currentColumnIndex++);
    }
}

