/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.data.conversion;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.data.conversion.ConverterIfc;
import java.math.BigDecimal;

public class NumberConverter
implements ConverterIfc {
    @Override
    public EvaluationValue convert(Object object, ExpressionConfiguration configuration) {
        BigDecimal bigDecimal;
        if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)object;
        } else if (object instanceof Double) {
            bigDecimal = new BigDecimal(Double.toString((Double)object), configuration.getMathContext());
        } else if (object instanceof Float) {
            bigDecimal = BigDecimal.valueOf(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            bigDecimal = BigDecimal.valueOf(((Integer)object).intValue());
        } else if (object instanceof Long) {
            bigDecimal = BigDecimal.valueOf((Long)object);
        } else if (object instanceof Short) {
            bigDecimal = BigDecimal.valueOf(((Short)object).shortValue());
        } else if (object instanceof Byte) {
            bigDecimal = BigDecimal.valueOf(((Byte)object).byteValue());
        } else {
            throw this.illegalArgument(object);
        }
        return EvaluationValue.numberValue(bigDecimal);
    }

    @Override
    public boolean canConvert(Object object) {
        return object instanceof BigDecimal || object instanceof Double || object instanceof Float || object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte;
    }
}

