/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.basic;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.functions.basic.AbstractMinMaxFunction;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;

@FunctionParameters(value={@FunctionParameter(name="firstValue"), @FunctionParameter(name="additionalValues", isVarArg=true)})
public class AverageFunction
extends AbstractMinMaxFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        MathContext mathContext = expression.getConfiguration().getMathContext();
        BigDecimal average = this.average(mathContext, parameterValues);
        return expression.convertValue(average);
    }

    private BigDecimal average(MathContext mathContext, EvaluationValue ... parameterValues) {
        SumAndCount aux = new SumAndCount();
        for (EvaluationValue parameter : parameterValues) {
            aux = aux.plus(this.recursiveSumAndCount(parameter));
        }
        return aux.sum.divide(aux.count, mathContext);
    }

    private SumAndCount recursiveSumAndCount(EvaluationValue parameter) {
        SumAndCount aux = new SumAndCount();
        if (parameter.isArrayValue()) {
            for (EvaluationValue element : parameter.getArrayValue()) {
                aux = aux.plus(this.recursiveSumAndCount(element));
            }
            return aux;
        }
        return new SumAndCount(parameter.getNumberValue(), BigDecimal.ONE);
    }

    private final class SumAndCount {
        private final BigDecimal sum;
        private final BigDecimal count;

        private SumAndCount() {
            this(BigDecimal.ZERO, BigDecimal.ZERO);
        }

        private SumAndCount(BigDecimal sum, BigDecimal count) {
            this.sum = sum;
            this.count = count;
        }

        private SumAndCount plus(SumAndCount other) {
            return new SumAndCount(this.sum.add(other.sum), this.count.add(other.count));
        }
    }
}

