/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.data.conversion;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.data.conversion.ArrayConverter;
import com.ezylang.evalex.data.conversion.BooleanConverter;
import com.ezylang.evalex.data.conversion.ConverterIfc;
import com.ezylang.evalex.data.conversion.DateTimeConverter;
import com.ezylang.evalex.data.conversion.DurationConverter;
import com.ezylang.evalex.data.conversion.EvaluationValueConverterIfc;
import com.ezylang.evalex.data.conversion.ExpressionNodeConverter;
import com.ezylang.evalex.data.conversion.NumberConverter;
import com.ezylang.evalex.data.conversion.StringConverter;
import com.ezylang.evalex.data.conversion.StructureConverter;
import java.util.Arrays;
import java.util.List;

public class DefaultEvaluationValueConverter
implements EvaluationValueConverterIfc {
    static final List<ConverterIfc> converters = Arrays.asList(new NumberConverter(), new StringConverter(), new BooleanConverter(), new DateTimeConverter(), new DurationConverter(), new ExpressionNodeConverter(), new ArrayConverter(), new StructureConverter());

    @Override
    public EvaluationValue convertObject(Object object, ExpressionConfiguration configuration) {
        if (object == null) {
            return EvaluationValue.NULL_VALUE;
        }
        if (object instanceof EvaluationValue) {
            return (EvaluationValue)object;
        }
        for (ConverterIfc converter : converters) {
            if (!converter.canConvert(object)) continue;
            return converter.convert(object, configuration);
        }
        if (configuration.isBinaryAllowed()) {
            return EvaluationValue.binaryValue(object);
        }
        throw new IllegalArgumentException("Unsupported data type '" + object.getClass().getName() + "'");
    }
}

