/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.datetime;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.datetime.ZoneIdConverter;
import com.ezylang.evalex.parser.Token;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

@FunctionParameter(name="parameters", isVarArg=true)
public class DateTimeTodayFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        ZoneId zoneId = this.parseZoneId(expression, functionToken, parameterValues);
        Instant today = LocalDate.now().atStartOfDay(zoneId).toInstant();
        return expression.convertValue(today);
    }

    private ZoneId parseZoneId(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        if (parameterValues.length > 0 && !parameterValues[0].isNullValue()) {
            return ZoneIdConverter.convert(functionToken, parameterValues[0].getStringValue());
        }
        return expression.getConfiguration().getZoneId();
    }
}

