/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Preconditions;
import io.airlift.airline.UsageHelper;
import io.airlift.airline.UsagePrinter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CommandUsage {
    private final int columnSize;
    private final Comparator<? super OptionMetadata> optionComparator;

    public CommandUsage() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.optionComparator = optionComparator;
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(programName, groupName, commandName, command, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, StringBuilder out) {
        this.usage(programName, groupName, commandName, command, new UsagePrinter(out, this.columnSize));
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, UsagePrinter out) {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(commandName).append("-").append(command.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<OptionMetadata> options = new ArrayList<OptionMetadata>();
        if (programName != null) {
            synopsis.append(programName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            synopsis.append("[--]").append(UsageHelper.toUsage(arguments));
        }
        synopsis.newline();
        synopsis.newline();
        if (options.size() > 0 || arguments != null) {
            options = this.sortOptions(options);
            out.append("OPTIONS").newline();
            for (OptionMetadata option : options) {
                if (option.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(option)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(option.getDescription()).newline();
                descriptionPrinter.newline();
            }
            if (arguments != null) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append("--").newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options").newline();
                descriptionPrinter.newline();
                optionPrinter.append(UsageHelper.toDescription(arguments)).newline();
                descriptionPrinter.append(arguments.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
    }

    private List<OptionMetadata> sortOptions(List<OptionMetadata> options) {
        if (this.optionComparator != null) {
            options = new ArrayList<OptionMetadata>(options);
            Collections.sort(options, this.optionComparator);
        }
        return options;
    }
}

