/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Preconditions;
import io.airlift.airline.UsageHelper;
import io.airlift.airline.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class GlobalUsage {
    private final int columnSize;
    private final Comparator<? super OptionMetadata> optionComparator;

    public GlobalUsage() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public GlobalUsage(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public GlobalUsage(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.optionComparator = optionComparator;
    }

    public void usage(GlobalMetadata global) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(GlobalMetadata global, StringBuilder out) {
        this.usage(global, new UsagePrinter(out, this.columnSize));
    }

    public void usage(GlobalMetadata global, UsagePrinter out) {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(UsageHelper.toSynopsisUsage(global.getOptions())).append("<command> [<args>]").newline().newline();
        ArrayList<OptionMetadata> options = new ArrayList<OptionMetadata>(global.getOptions());
        if (options.size() > 0) {
            if (this.optionComparator != null) {
                Collections.sort(options, this.optionComparator);
            }
            out.append("OPTIONS").newline();
            for (OptionMetadata option : options) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(option)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(option.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            this.printCommandDescription(commandPrinter, null, command);
        }
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            for (CommandMetadata command : group.getCommands()) {
                this.printCommandDescription(commandPrinter, group, command);
            }
        }
    }

    private void printCommandDescription(UsagePrinter commandPrinter, @Nullable CommandGroupMetadata group, CommandMetadata command) {
        if (group != null) {
            commandPrinter.append(group.getName());
        }
        commandPrinter.append(command.getName()).newline();
        if (command.getDescription() != null) {
            commandPrinter.newIndentedPrinter(4).append(command.getDescription()).newline();
        }
        commandPrinter.newline();
    }
}

