/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.airline.Accessor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ArgumentsMetadata {
    private final String title;
    private final String description;
    private final String usage;
    private final boolean required;
    private final Set<Accessor> accessors;

    public ArgumentsMetadata(String title, String description, String usage, boolean required, Iterable<Field> path) {
        Objects.requireNonNull(title, "title is null");
        Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((boolean)Streams.stream(path).findAny().isPresent(), (Object)"path is empty");
        this.title = title;
        this.description = description;
        this.usage = usage;
        this.required = required;
        this.accessors = ImmutableSet.of((Object)new Accessor(path));
    }

    public ArgumentsMetadata(Iterable<ArgumentsMetadata> arguments) {
        Objects.requireNonNull(arguments, "arguments is null");
        Preconditions.checkArgument((boolean)Streams.stream(arguments).findAny().isPresent(), (Object)"arguments is empty");
        ArgumentsMetadata first = arguments.iterator().next();
        this.title = first.title;
        this.description = first.description;
        this.usage = first.usage;
        this.required = first.required;
        HashSet<Accessor> accessors = new HashSet<Accessor>();
        for (ArgumentsMetadata other : arguments) {
            Preconditions.checkArgument((boolean)first.equals(other), (String)"Conflicting arguments definitions: %s, %s", (Object)first, (Object)other);
            accessors.addAll(other.getAccessors());
        }
        this.accessors = ImmutableSet.copyOf(accessors);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Set<Accessor> getAccessors() {
        return this.accessors;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentsMetadata that = (ArgumentsMetadata)o;
        if (this.required != that.required) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        return !(this.usage != null ? !this.usage.equals(that.usage) : that.usage != null);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.usage != null ? this.usage.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArgumentsMetadata");
        sb.append("{title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", usage='").append(this.usage).append('\'');
        sb.append(", required=").append(this.required);
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }
}

