/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bootstrap;

import com.facebook.airlift.bootstrap.Executed;
import com.facebook.airlift.bootstrap.TestLifeCycleManager;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;

public class ExecutedInstance
extends Executed {
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch endLatch = new CountDownLatch(1);

    @Inject
    public ExecutedInstance() {
    }

    public void waitForStart() throws InterruptedException {
        this.startLatch.await();
    }

    public void waitForEnd() throws InterruptedException {
        this.endLatch.await();
    }

    public void run() {
        TestLifeCycleManager.note("Starting");
        this.startLatch.countDown();
        try {
            if (!Thread.interrupted()) {
                try {
                    Thread.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            TestLifeCycleManager.note("Done");
            this.endLatch.countDown();
        }
    }
}

